/*
 * Decompiled with CFR 0.152.
 */
package dvi.util.progress;

import dvi.api.DviContextSupport;
import dvi.util.progress.AbstractProgressModel;
import dvi.util.progress.ProgressEvent;
import dvi.util.progress.ProgressItem;
import dvi.util.progress.ProgressListener;
import dvi.util.progress.ProgressRecorder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ProgressReporter
extends AbstractProgressModel
implements ProgressListener {
    private final List<ProgressRecorder> recorders = new ArrayList<ProgressRecorder>();
    private volatile ProgressItem item;

    public ProgressReporter(DviContextSupport dcs) {
        super(dcs);
    }

    public AbstractProgressModel[] getProgressRecorders() {
        return this.recorders.toArray(new ProgressRecorder[this.recorders.size()]);
    }

    public void addProgressRecorder(ProgressRecorder recorder) {
        if (recorder == null) {
            return;
        }
        if (this.recorders.contains(recorder)) {
            return;
        }
        recorder.addProgressListener(this);
        this.recorders.add(recorder);
    }

    public void removeProgressRecorder(AbstractProgressModel recorder) {
        if (recorder == null) {
            return;
        }
        if (!this.recorders.contains(recorder)) {
            return;
        }
        this.recorders.remove(recorder);
        recorder.removeProgressListener(this);
    }

    public ProgressItem getMostRecentItem() {
        return this.item;
    }

    protected void update() {
        ArrayList<ProgressItem> list = new ArrayList<ProgressItem>();
        for (ProgressRecorder recorder : this.recorders) {
            ProgressItem[] items = recorder.getItems();
            if (items.length == 0) continue;
            ProgressItem item = items[items.length - 1];
            list.add(item);
        }
        Collections.sort(list, new Comparator<ProgressItem>(){

            @Override
            public int compare(ProgressItem o1, ProgressItem o2) {
                long s2;
                long s1 = o1.getSerialNumber();
                if (s1 < (s2 = o2.getSerialNumber())) {
                    return -1;
                }
                if (s1 > s2) {
                    return 1;
                }
                return 0;
            }
        });
        if (list.size() > 0) {
            this.item = (ProgressItem)list.get(list.size() - 1);
        }
    }

    public void progressClose(ProgressEvent e) {
        this.update();
        this.fireProgressCloseEvent(e.getManagedItem());
    }

    public void progressOpen(ProgressEvent e) {
        this.update();
        this.fireProgressOpenEvent(e.getManagedItem());
    }

    public void progressUpdate(ProgressEvent e) {
        this.update();
        this.fireProgressUpdateEvent(e.getManagedItem());
    }
}

