/*
 * Decompiled with CFR 0.152.
 */
package dvi.util.progress;

import dvi.DviObject;
import dvi.api.DviContextSupport;
import dvi.util.progress.ProgressEvent;
import dvi.util.progress.ProgressListener;
import dvi.util.progress.ProgressRecorder;
import java.io.PrintStream;

public class ProgressLogger
extends DviObject
implements ProgressListener {
    private final PrintStream out;
    private ProgressRecorder recorder;

    public ProgressLogger(DviContextSupport dcs, PrintStream out, ProgressRecorder recorder) {
        super(dcs);
        this.out = out;
        this.setProgressRecorder(recorder);
    }

    public void setProgressRecorder(ProgressRecorder recorder) {
        if (this.recorder != null) {
            this.recorder.removeProgressListener(this);
        }
        this.recorder = recorder;
        if (this.recorder != null) {
            this.recorder.addProgressListener(this);
        }
    }

    public ProgressRecorder getProgressRecorder() {
        return this.recorder;
    }

    public void progressClose(ProgressEvent e) {
        this.out.println("[END] " + e.getItem());
    }

    public void progressOpen(ProgressEvent e) {
        this.out.println("[BEGIN] " + e.getItem());
    }

    public void progressUpdate(ProgressEvent e) {
    }
}

