/*
 * Decompiled with CFR 0.152.
 */
package dvi.util.progress;

import dvi.DviException;
import dvi.DviObject;
import dvi.util.progress.AbstractProgressModel;
import dvi.util.progress.ProgressItem;
import java.util.logging.Logger;

public class ManagedProgressItem
extends DviObject
implements ProgressItem {
    private static final Logger LOGGER = Logger.getLogger(ManagedProgressItem.class.getName());
    public static final int STATE_INIT = 0;
    public static final int STATE_OPEN = 1;
    public static final int STATE_CLOSED = 2;
    private final AbstractProgressModel recorder;
    private final ProgressItem item;
    private int start;
    private int end;
    private int current;
    private int state = 0;

    public ManagedProgressItem(AbstractProgressModel recorder, ProgressItem item) {
        super(recorder);
        this.recorder = recorder;
        this.item = item;
    }

    public boolean isOpen() {
        return this.state == 1;
    }

    public boolean isClosed() {
        return this.state == 2;
    }

    public AbstractProgressModel getProgressRecorder() {
        return this.recorder;
    }

    public ProgressItem getOriginalItem() {
        return this.item;
    }

    public void close() throws DviException {
        if (this.state == 0) {
            throw new IllegalStateException("Item is never opened.");
        }
        if (this.state == 2) {
            return;
        }
        this.state = 2;
        this.current = this.end;
        this.item.close();
        LOGGER.fine("close: " + this.item);
        this.recorder.fireProgressCloseEvent(this);
    }

    public void open(int start, int end) throws DviException {
        if (this.state != 0) {
            throw new IllegalStateException("Item is not open or closed.");
        }
        this.state = 1;
        this.start = start;
        this.current = start;
        this.end = end;
        this.item.open(start, end);
        LOGGER.fine("opened: " + this.item);
        this.recorder.fireProgressOpenEvent(this);
    }

    public void update(int current) throws DviException {
        if (this.state != 1) {
            throw new IllegalStateException("Item is not open or closed.");
        }
        this.current = current;
        this.item.update(current);
        LOGGER.fine("update: " + this.item);
        this.recorder.fireProgressUpdateEvent(this);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.item.toString() + "]";
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (DviException e) {
            e.printStackTrace();
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getState() {
        return this.state;
    }
}

