/*
 * Decompiled with CFR 0.152.
 */
package dvi.util;

import dvi.DviException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DviUtils {
    private static final Logger LOGGER = Logger.getLogger(DviUtils.class.getName());
    private static final String OS_NAME = System.getProperty("os.name");
    private static final UUID applicationInstanceUUID = UUID.randomUUID();
    private static final AtomicLong serializer = new AtomicLong();
    private static final Pattern patEnv = Pattern.compile("^([^=]*)=(.*)$");

    public static long generateSerialNumber() {
        return serializer.incrementAndGet();
    }

    public static UUID getApplicationInstanceUUID() {
        return applicationInstanceUUID;
    }

    public static String generateUniqueId() {
        String uniqueId = DviUtils.getApplicationInstanceUUID().toString() + "--" + DviUtils.generateSerialNumber();
        return uniqueId;
    }

    private DviUtils() {
    }

    public static boolean isFile(URL url) {
        if (url == null) {
            return false;
        }
        return "file".equals(url.getProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeStringToFile(File file, String data) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            byte[] buf = data.getBytes();
            fos.write(buf);
            Object var5_4 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fos == null) throw throwable;
            fos.flush();
            DviUtils.silentClose(fos);
            throw throwable;
        }
        fos.flush();
        DviUtils.silentClose(fos);
    }

    public static File toLocalFile(URL url) throws DviException {
        if (url == null) {
            return null;
        }
        if ("file".equals(url.getProtocol())) {
            return new File(url.getPath());
        }
        throw new DviException("URL does not point to a local file. " + url);
    }

    public static String md5Hex(String ps) {
        if (ps == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(ps.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "0";
        }
    }

    public static Map<String, String> getLoginShellEnvPosix() throws IOException, InterruptedException {
        return DviUtils.getLoginShellEnvPosix(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getLoginShellEnvPosix(String shell) throws IOException, InterruptedException {
        String[] cmds = new String[]{"printenv"};
        if (shell != null) {
            cmds = new String[]{shell, "-l", "-c", "printenv"};
        }
        Process proc = Runtime.getRuntime().exec(cmds);
        HashMap<String, String> map = new HashMap<String, String>();
        InputStream is = proc.getInputStream();
        proc.getOutputStream().close();
        proc.getErrorStream().close();
        Scanner s = new Scanner(proc.getInputStream());
        try {
            while (s.hasNext()) {
                String line = s.nextLine();
                Matcher mat = patEnv.matcher(line);
                if (!mat.matches()) continue;
                String key = mat.group(1);
                String value = mat.group(2);
                LOGGER.finest("key=" + key + " value=" + value);
                map.put(key, value);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            DviUtils.silentClose(is);
            throw throwable;
        }
        DviUtils.silentClose(is);
        proc.waitFor();
        return map;
    }

    public static String getPathByLoginShellPosix() throws IOException, InterruptedException {
        String path = null;
        Map<String, String> env0 = DviUtils.getLoginShellEnvPosix(null);
        String shell = env0.get("SHELL");
        if (shell != null) {
            Map<String, String> env1 = DviUtils.getLoginShellEnvPosix(shell);
            path = env1.get("PATH");
        }
        return path;
    }

    public static String join(String left, String mid, String right, String[] arg) {
        if (arg == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        left = DviUtils.wrapNull(left, "");
        mid = DviUtils.wrapNull(mid, "");
        right = DviUtils.wrapNull(right, "");
        String sep = left;
        for (String s : arg) {
            sb.append(sep + s);
            sep = mid;
        }
        sb.append(right);
        return sb.toString();
    }

    public static String join(String sep, String[] args) {
        return DviUtils.join(null, sep, null, args);
    }

    public static <T> T wrapNull(T value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static Process unsafeRunCommandByShell(String[] cmds, String[] envp, File workDir) throws IOException {
        Process p = null;
        if (!DviUtils.isWindows()) {
            try {
                Map<String, String> env = DviUtils.getLoginShellEnvPosix();
                String shell = env.get("SHELL");
                if (shell != null) {
                    p = DviUtils.unsafeRunCommandByShellPosix(shell, true, cmds, envp, workDir);
                }
            }
            catch (InterruptedException e) {
                LOGGER.warning(e.toString());
            }
        }
        if (p == null) {
            p = Runtime.getRuntime().exec(cmds, envp, workDir);
        }
        return p;
    }

    public static Process unsafeRunCommandByShellPosix(String shell, boolean useLoginShell, String[] cmds, String[] envp, File workDir) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(shell);
        if (useLoginShell) {
            list.add("-l");
        }
        String[] cmdLine = list.toArray(new String[list.size()]);
        StringBuilder subCommand = new StringBuilder();
        for (String cmd : cmds) {
            subCommand.append(cmd + " ");
        }
        LOGGER.fine("running shell: " + DviUtils.join(" ", cmdLine));
        LOGGER.fine("running command: " + subCommand.toString());
        Process proc = Runtime.getRuntime().exec(cmdLine, envp, workDir);
        PrintWriter out = new PrintWriter(proc.getOutputStream());
        out.println(subCommand.toString());
        out.close();
        return proc;
    }

    public static Thread dumpStreamAsync(final String name, final InputStream is, final PrintStream out) {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Scanner s = new Scanner(is);
                try {
                    while (s.hasNext()) {
                        String line = s.nextLine();
                        if (out != null) {
                            out.println("[" + name + "] " + line);
                        }
                        if (!LOGGER.isLoggable(Level.FINER)) continue;
                        LOGGER.finer("[" + name + "] " + line);
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    try {
                        s.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    s.close();
                }
                catch (Exception e) {}
            }
        });
        t.start();
        return t;
    }

    public static <T> T head(T[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array[0];
    }

    public static void logLinesFromStream(String name, InputStream is, Logger logger, Level level) {
        if (logger == null || !logger.isLoggable(level)) {
            return;
        }
        Scanner s = new Scanner(is);
        while (s.hasNext()) {
            String line = s.nextLine();
            LOGGER.log(level, "[" + name + "] " + line);
        }
    }

    public static void addLinesFromStream(List<String> output, InputStream is) {
        DviUtils.addLinesFromStream(output, is, null, Level.SEVERE, null);
    }

    public static void addLinesFromStream(List<String> output, InputStream is, Logger logger, Level level, PrintStream out) {
        if (output == null) {
            return;
        }
        Scanner s = new Scanner(is);
        while (s.hasNext()) {
            String line = s.nextLine();
            output.add(line);
            if (logger != null && logger.isLoggable(level)) {
                logger.log(level, line);
            }
            if (out == null) continue;
            out.println(line);
            out.flush();
        }
    }

    public static Thread dumpStreamAsync(final String name, final InputStream is, final Logger logger, final Level level) {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    DviUtils.logLinesFromStream(name, is, logger, level);
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    DviUtils.silentClose(is);
                    throw throwable;
                }
                DviUtils.silentClose(is);
            }
        });
        t.start();
        return t;
    }

    public static boolean isMacOSX() {
        return OS_NAME.startsWith("Mac OS X");
    }

    public static boolean isWindows() {
        return OS_NAME.startsWith("Windows");
    }

    public static void silentClose(Closeable s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (Exception ex) {
            DviUtils.logStackTrace(LOGGER, Level.WARNING, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToByteArray(File file) throws IOException {
        byte[] byArray;
        if (file == null) {
            return null;
        }
        int len = (int)file.length();
        FileInputStream is = new FileInputStream(file);
        try {
            byte[] buf = new byte[len];
            if (len != is.read(buf)) {
                throw new IOException("Failed to read file content");
            }
            byArray = buf;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DviUtils.silentClose(is);
            throw throwable;
        }
        DviUtils.silentClose(is);
        return byArray;
    }

    public static String readFileToString(File file, String encoding) throws IOException {
        byte[] buf = DviUtils.readFileToByteArray(file);
        if (buf != null) {
            return new String(buf, encoding);
        }
        return null;
    }

    public static String readFileToString(File file) throws IOException {
        byte[] buf = DviUtils.readFileToByteArray(file);
        if (buf != null) {
            return new String(buf);
        }
        return null;
    }

    public static String[] readLinesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        return DviUtils.readLinesFromStream(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readLinesFromStream(InputStream is) throws IOException {
        String[] stringArray;
        ArrayList<String> list = new ArrayList<String>();
        Scanner s = new Scanner(is);
        try {
            while (s.hasNext()) {
                String line = s.nextLine();
                list.add(line);
            }
            stringArray = list.toArray(new String[list.size()]);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DviUtils.silentClose(is);
            throw throwable;
        }
        DviUtils.silentClose(is);
        return stringArray;
    }

    public static String[] removeComments(String[] list, String lineCommentStart) {
        if (list == null) {
            return list;
        }
        ArrayList<String> out = new ArrayList<String>();
        for (String item : list) {
            int pos = item.indexOf(lineCommentStart);
            String line = item;
            if (pos != -1) {
                line = line.substring(0, pos);
            }
            if ((line = line.trim()).length() <= 0) continue;
            out.add(line);
        }
        return out.toArray(new String[out.size()]);
    }

    public static String joinPath(String[] args) {
        if (args == null) {
            return null;
        }
        return DviUtils.join(File.pathSeparator, args);
    }

    public static void logStackTrace(Logger logger, Level level, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(t.toString());
        for (StackTraceElement e : t.getStackTrace()) {
            pw.println("at " + e.getClassName() + "." + e.getMethodName() + "(" + e.getFileName() + ":" + e.getLineNumber() + ")");
        }
        logger.log(level, sw.toString());
    }

    public static File toFile(URL url) {
        if (url == null) {
            return null;
        }
        if (!DviUtils.isFile(url)) {
            throw new IllegalArgumentException("URL does not point to a local file: " + url);
        }
        return new File(url.getPath());
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static String join(String sep, Collection<String> list) {
        if (list == null) {
            return null;
        }
        return DviUtils.join(sep, list.toArray(new String[list.size()]));
    }
}

