/*
 * Decompiled with CFR 0.152.
 */
package dvi.util;

import dvi.util.DviUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.logging.Logger;

public class DviDesktop {
    private static final Logger LOGGER = Logger.getLogger(DviDesktop.class.getName());
    private static final DviDesktop instance = new DviDesktop();

    private DviDesktop() {
    }

    public static DviDesktop getDesktop() {
        return instance;
    }

    public static boolean isDesktopSupported() {
        if (DviUtils.isMacOSX()) {
            return true;
        }
        return DviUtils.isWindows();
    }

    public void browse(URI uri) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void open(File file) throws IOException {
        if (DviUtils.isMacOSX()) {
            try {
                Class<?> cls = Class.forName("com.apple.eio.FileManager");
                Method openURL = cls.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, file.toURL().toExternalForm());
            }
            catch (SecurityException e) {
                LOGGER.warning(e.toString());
            }
            catch (IllegalArgumentException e) {
                LOGGER.warning(e.toString());
            }
            catch (ClassNotFoundException e) {
                LOGGER.warning(e.toString());
            }
            catch (NoSuchMethodException e) {
                LOGGER.warning(e.toString());
            }
            catch (IllegalAccessException e) {
                LOGGER.warning(e.toString());
            }
            catch (InvocationTargetException e) {
                LOGGER.warning(e.toString());
            }
        } else if (DviUtils.isWindows()) {
            String[] commandLine = new String[]{"cmd.exe", "/c", "start", file.getAbsolutePath()};
            try {
                Process p = Runtime.getRuntime().exec(commandLine, null, null);
                int ret = p.waitFor();
                LOGGER.fine("Process exit with retcode: " + ret);
            }
            catch (InterruptedException e) {
                LOGGER.warning(e.toString());
            }
        } else {
            LOGGER.severe("This platform does not support file association.");
        }
    }
}

