/*
 * Decompiled with CFR 0.152.
 */
package dvi.special;

import dvi.DviException;
import dvi.DviObject;
import dvi.DviSize;
import dvi.api.DviContextSupport;
import dvi.util.CommandShell;
import dvi.util.DviUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Scanner;
import java.util.Vector;
import java.util.logging.Logger;

public class GhostScript
extends DviObject {
    private static final Logger LOGGER = Logger.getLogger(GhostScript.class.getName());
    private String dev = "png256";
    private File outputFile;
    private File inputFile;
    private int dpi = 300;
    private int firstPage = -1;
    private int lastPage = -1;
    private DviSize size = null;
    private int textAlpha = 4;
    private int graphicsAlpha = 4;
    private String stdoutData = null;
    private String stderrData = null;

    public GhostScript(DviContextSupport dcs) {
        super(dcs);
    }

    public void setDevice(String dev) {
        this.dev = dev;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public void setResolution(int dpi) {
        this.dpi = dpi;
    }

    public void setPaperSize(DviSize size) {
        this.size = size;
    }

    public void work() throws DviException, IOException {
        Vector<String> cl = new Vector<String>();
        String gscmd = this.getDviContext().getExecutableName("gs");
        cl.add(gscmd);
        cl.add("-dSAFER");
        cl.add("-dPARANOIDSAFER");
        cl.add("-dDELAYSAFER");
        cl.add("-dNOPAUSE");
        cl.add("-dBATCH");
        cl.add("-sDEVICE=" + this.dev);
        if (this.outputFile != null) {
            cl.add("-sOutputFile=" + this.outputFile);
        }
        if (this.firstPage > 0) {
            cl.add("-dFirstPage=" + this.firstPage);
        }
        if (this.lastPage > 0) {
            cl.add("-dLastPage=" + this.lastPage);
        }
        cl.add("-r" + this.dpi);
        if (this.size != null) {
            cl.add("-g" + this.size);
        }
        if (this.inputFile != null) {
            cl.add("-f" + this.inputFile);
        }
        if (this.textAlpha > 0) {
            cl.add("-dTextAlphaBits=" + this.textAlpha);
        }
        if (this.graphicsAlpha > 0) {
            cl.add("-dGraphicsAlphaBits=" + this.graphicsAlpha);
        }
        CommandShell cs = new CommandShell();
        cs.setCommandLine(cl);
        cs.setHandler(new CommandShell.Handler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleStderr(InputStream in) throws IOException {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                try {
                    Scanner s = new Scanner(in);
                    while (s.hasNext()) {
                        String line = s.nextLine();
                        pw.println(line);
                    }
                }
                finally {
                    DviUtils.silentClose(in);
                }
                LOGGER.finer(sw.toString());
                GhostScript.this.stderrData = sw.toString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleStdout(InputStream in) throws IOException {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                Scanner s = new Scanner(in);
                try {
                    while (s.hasNext()) {
                        String line = s.nextLine();
                        pw.println(line);
                    }
                }
                finally {
                    DviUtils.silentClose(in);
                }
                LOGGER.finer(sw.toString());
                GhostScript.this.stdoutData = sw.toString();
            }
        });
        cs.execute();
    }

    public void setTextAlpha(int textAlpha) {
        this.textAlpha = textAlpha;
    }

    public int getTextAlpha() {
        return this.textAlpha;
    }

    public void setGraphicsAlpha(int graphicsAlpha) {
        this.graphicsAlpha = graphicsAlpha;
    }

    public int getGraphicsAlpha() {
        return this.graphicsAlpha;
    }

    public void setFirstPage(int firstPage) {
        this.firstPage = firstPage;
    }

    public int getFirstPage() {
        return this.firstPage;
    }

    public void setLastPage(int lastPage) {
        this.lastPage = lastPage;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    public String getStdoutData() {
        return this.stdoutData;
    }

    public String getStderrData() {
        return this.stderrData;
    }
}

