/*
 * Decompiled with CFR 0.152.
 */
package dvi.special;

import dvi.DviException;
import dvi.DviObject;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.api.DviPage;
import dvi.api.HasURL;
import dvi.ctx.DviToolkit;
import dvi.gui.swing.ViewSpec;
import dvi.special.DviImage;
import dvi.special.GhostScript;
import dvi.util.DviUtils;
import dvi.util.concurrent.Computation;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPS2ImagePreparator
extends DviObject
implements Computation<String, DviImage> {
    private static final Logger LOGGER = Logger.getLogger(EPS2ImagePreparator.class.getName());
    private final DviPage page;
    private final ViewSpec viewSpec;
    private final String postScriptData;
    private final String hash;
    private static final boolean DELETE_PSFILE_IMMEDIATELY = false;

    public EPS2ImagePreparator(DviContextSupport dcs, DviPage page, ViewSpec viewSpec) throws DviException {
        super(dcs);
        this.page = page;
        this.viewSpec = viewSpec;
        DviToolkit utils = this.getDviContext().getDviToolkit();
        this.postScriptData = utils.getEmbeddedPostScript(page, viewSpec);
        this.hash = DviUtils.md5Hex(this.postScriptData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DviImage call() throws Exception {
        DviImage dviImage;
        if (this.postScriptData == null) {
            return null;
        }
        File dir = this.getDviContext().getTemporaryDirectory();
        String key = this.getCacheKey();
        String keyHash = DviUtils.md5Hex(key);
        String basename = String.format("dvibrowser--%s--%08d", keyHash, this.page.getPageNumber());
        String imgExt = this.getViewSpec().getEpsImageFileExtension();
        File imgFile = new File(dir, basename + imgExt);
        if (!imgFile.exists()) {
            LOGGER.fine("Now creating postscript image for page " + this.page);
            LOGGER.fine("Using key=" + key);
            LOGGER.fine("Using keyHash=" + keyHash);
            LOGGER.finer("PostScriptData= " + this.postScriptData);
            File psFile = new File(dir, basename + ".ps");
            File tmpFile = File.createTempFile(basename, imgExt, dir);
            try {
                psFile.deleteOnExit();
                DviUtils.writeStringToFile(psFile, this.postScriptData);
                GhostScript gs = new GhostScript(this);
                gs.setInputFile(psFile);
                gs.setOutputFile(tmpFile);
                gs.setResolution(this.viewSpec.getEpsResolutionDpi());
                gs.setDevice(this.getViewSpec().getEpsImageDeviceName());
                gs.work();
                if (!tmpFile.renameTo(imgFile)) {
                    throw new DviException("Failed to write image file: " + imgFile);
                }
                imgFile.deleteOnExit();
                LOGGER.fine("Saved image to " + imgFile);
            }
            finally {
                LOGGER.fine("Finished creating postscript image for page " + this.page);
                tmpFile.delete();
            }
        }
        try {
            BufferedImage image = ImageIO.read(imgFile);
            dviImage = null;
            if (image != null) {
                dviImage = new DviImage(image, this.viewSpec.getEpsResolutionDpi());
            }
        }
        catch (OutOfMemoryError e) {
            LOGGER.severe("Unable to render image: imgFile=" + imgFile + " filesize=" + imgFile.length());
            DviUtils.logStackTrace(LOGGER, Level.SEVERE, e);
            throw e;
        }
        return dviImage;
    }

    @Override
    public String getCacheKey() {
        String pageKey = null;
        try {
            DviDocument doc = this.page.getDocument();
            if (doc instanceof HasURL) {
                URL url = ((HasURL)((Object)doc)).getURL();
                pageKey = url.toExternalForm() + "#page" + this.page.getPageNumber();
            }
        }
        catch (DviException e) {
            LOGGER.warning(e.toString());
            pageKey = this.page.getCacheKey();
        }
        return this.getClass().getName() + "--" + this.hash + "-" + pageKey;
    }

    public ViewSpec getViewSpec() {
        return this.viewSpec;
    }

    public DviPage getPage() {
        return this.page;
    }
}

