/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.DviColor;
import dvi.DviException;
import dvi.DviPoint;
import dvi.DviRect;
import dvi.DviResolution;
import dvi.api.BinaryDevice;
import dvi.api.ImageDevice;
import dvi.render.AbstractDevice;

public class RunLengthSampler
extends AbstractDevice
implements BinaryDevice {
    private final ImageDevice out;
    private final int sf;
    private int level = 0;
    private boolean needPaint = false;
    private DviRect cpy;
    private int l_pad_sf;
    private int[] s_buf = null;
    private int cph;
    private int s_sx;
    private int s_sy;
    private int yy;
    private int[] l_buf = null;
    private int[] empty_buf = null;
    private int xx;
    private int x_pos;

    public RunLengthSampler(ImageDevice out) throws DviException {
        super(out.getResolution());
        this.out = out;
        this.sf = out.getResolution().shrinkFactor();
    }

    public DviResolution getResolution() throws DviException {
        return this.out.getResolution();
    }

    public void begin() throws DviException {
        if (this.level == 0) {
            this.point = this.out.getReferencePoint().magnify(this.sf);
            super.setColor(this.out.getColor());
            this.out.begin(this.sf * this.sf);
            this.out.save();
            this.out.setReferencePoint(DviPoint.ORIGIN);
        } else {
            this.out.save();
        }
        ++this.level;
    }

    public void end() throws DviException {
        --this.level;
        this.out.restore();
        if (this.level == 0) {
            this.out.end();
        }
    }

    public void setColor(DviColor color) throws DviException {
        super.setColor(color);
        this.out.setColor(color);
    }

    public boolean beginRaster(int gw_sf, int gh_sf) throws DviException {
        this.out.save();
        this.needPaint = false;
        DviRect r_in_sf = new DviRect(this.point, gw_sf, gh_sf);
        DviRect r_in = r_in_sf.shrink(this.sf);
        this.l_pad_sf = r_in_sf.x() - r_in.x() * this.sf;
        int t_pad_sf = r_in_sf.y() - r_in.y() * this.sf;
        this.cpy = r_in;
        DviRect bounds = this.out.getBounds();
        if (bounds != null) {
            this.cpy = this.cpy.intersect(bounds);
        }
        if (this.cpy.isEmpty()) {
            return false;
        }
        this.s_buf = new int[this.cpy.width()];
        this.yy = t_pad_sf;
        this.s_sx = this.cpy.x() - r_in.x();
        this.s_sy = this.cpy.y() - r_in.y();
        this.l_buf = new int[r_in.width()];
        this.empty_buf = new int[r_in.width()];
        this.cph = this.cpy.height();
        this.out.setReferencePoint(this.cpy.topLeft());
        this.needPaint = this.out.beginImage(this.cpy.width(), this.cpy.height());
        return this.needPaint;
    }

    public void endRaster() throws DviException {
        this.out.restore();
        this.flushLine();
        this.out.endImage();
        this.s_buf = null;
        this.l_buf = null;
        this.empty_buf = null;
    }

    private void flushLine() throws DviException {
        if (!this.needPaint) {
            return;
        }
        if (this.cpy.width() == 0) {
            return;
        }
        if (this.s_sy > 0) {
            --this.s_sy;
        } else if (this.cph > 0) {
            this.out.putLine(this.s_buf, 0, this.s_buf.length);
            --this.cph;
        }
    }

    public void beginLine() throws DviException {
        System.arraycopy(this.empty_buf, 0, this.l_buf, 0, this.l_buf.length);
        this.x_pos = 0;
        this.xx = this.l_pad_sf;
    }

    public void endLine(int count) throws DviException {
        int j;
        int left = this.sf - this.yy;
        if (left <= ++count) {
            for (j = 0; j < this.s_buf.length; ++j) {
                int n = j;
                this.s_buf[n] = this.s_buf[n] + this.l_buf[j + this.s_sx] * left;
            }
            this.flushLine();
            if ((count -= left) >= this.sf) {
                for (j = 0; j < this.s_buf.length; ++j) {
                    this.s_buf[j] = this.l_buf[j + this.s_sx] * this.sf;
                }
                while (count >= this.sf) {
                    this.flushLine();
                    count -= this.sf;
                }
            }
            System.arraycopy(this.empty_buf, 0, this.s_buf, 0, this.s_buf.length);
            this.yy = count;
        } else {
            this.yy += count;
        }
        if (count > 0) {
            for (j = 0; j < this.s_buf.length; ++j) {
                int n = j;
                this.s_buf[n] = this.s_buf[n] + this.l_buf[j + this.s_sx] * count;
            }
        }
    }

    public void putBits(int count, boolean paintFlag) throws DviException {
        if (paintFlag) {
            int left = this.sf - this.xx;
            if (left <= count) {
                int n = this.x_pos++;
                this.l_buf[n] = this.l_buf[n] + left;
                count -= left;
                while (count >= this.sf) {
                    int n2 = this.x_pos++;
                    this.l_buf[n2] = this.l_buf[n2] + this.sf;
                    count -= this.sf;
                }
                this.xx = count;
            } else {
                this.xx += count;
            }
            if (count > 0) {
                int n = this.x_pos;
                this.l_buf[n] = this.l_buf[n] + count;
            }
        } else {
            this.xx += count;
            this.x_pos += this.xx / this.sf;
            this.xx %= this.sf;
        }
    }
}

