/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.api.GammaCorrector;
import dvi.util.DviCache;

public class GammaCorrectorCache
implements GammaCorrector {
    private static final int MAX_LOOKUP_TABLE_SIZE = 65536;
    private int maxval;
    private LookupTable table;
    private boolean canLookUp;
    private final GammaCorrector gammaCorrector;
    private static final DviCache<String, LookupTable> cache = new DviCache(10);

    public static GammaCorrector wrap(GammaCorrector gammaCorrector) {
        return new GammaCorrectorCache(gammaCorrector);
    }

    private GammaCorrectorCache(GammaCorrector gammaCorrector) {
        this.gammaCorrector = gammaCorrector;
    }

    public void setMaxValue(int maxval) {
        this.maxval = maxval;
        if (maxval < 65536) {
            String key = this.gammaCorrector.getCacheKey() + "--" + maxval;
            LookupTable table = (LookupTable)cache.get(key);
            if (table == null) {
                table = new LookupTable(maxval);
                for (int i = 0; i <= maxval; ++i) {
                    ((LookupTable)table).data[i] = this.doCorrectGamma(i, maxval);
                }
                cache.put(key, table);
            }
            this.table = table;
            this.canLookUp = true;
        } else {
            this.canLookUp = false;
        }
    }

    public int correctGamma(int c, int maxval) {
        if (c < 0) {
            throw new IllegalArgumentException("c is negative");
        }
        if (maxval < 0) {
            throw new IllegalArgumentException("maxval is negative");
        }
        if (this.gammaCorrector == null) {
            return 0;
        }
        if (maxval != this.maxval) {
            this.setMaxValue(maxval);
        }
        if (this.canLookUp && c <= maxval) {
            return this.table.data[c];
        }
        return this.doCorrectGamma(c, maxval);
    }

    private int doCorrectGamma(int c, int maxval) {
        return this.gammaCorrector.correctGamma(c, maxval);
    }

    public GammaCorrector getGammaCorrector() {
        return this.gammaCorrector;
    }

    public String getCacheKey() {
        return null;
    }

    private static class LookupTable {
        private final int[] data;

        public LookupTable(int maxval) {
            this.data = new int[maxval + 1];
        }
    }
}

