/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.DviException;
import dvi.DviFontSpec;
import dvi.DviFontTable;
import dvi.DviObject;
import dvi.DviRegister;
import dvi.api.DevicePainter;
import dvi.api.DviContextSupport;
import dvi.api.DviExecutorContext;
import dvi.api.Geometer;
import dvi.api.GeometerContext;
import dvi.api.SimpleMetrics;
import dvi.cmd.DviBop;
import dvi.cmd.DviPostPost;
import dvi.cmd.DviPostamble;
import dvi.cmd.DviPreamble;
import java.util.Stack;
import java.util.logging.Logger;

public class BasicGeometer
extends DviObject
implements Geometer {
    private static final Logger LOGGER = Logger.getLogger(BasicGeometer.class.getName());
    protected DevicePainter dp;
    private GeometerContextImpl ctx = null;
    private DviFontTable ft = null;

    public BasicGeometer(DviContextSupport dcs) {
        super(dcs);
    }

    public void setPainter(DevicePainter dp) {
        this.dp = dp;
    }

    public void begin(DviExecutorContext ctx) throws DviException {
        this.ctx = new GeometerContextImpl();
        this.ctx.reg = new DviRegister();
        this.ctx.exe_ctx = ctx;
        this.ft = ctx.getData().getFontTable();
        this.dp.begin(this.ctx);
    }

    public void end() throws DviException {
        if (this.ctx.fs != null) {
            this.dp.endFont();
        }
        this.dp.end();
        this.ctx = null;
        this.ft = null;
    }

    public void doSet(int code) throws DviException {
        this.dp.drawChar(code);
        int tfmw = 0;
        if (this.ctx.sm != null) {
            tfmw = this.ctx.sm.getTfmWidth(code);
        }
        if (this.ctx.fs != null) {
            this.ctx.reg.addH(this.ctx.fs.tfmToDvi(tfmw));
        }
    }

    public void doSetRule(int width, int height) throws DviException {
        this.dp.drawRule(width, height);
        this.ctx.reg.addH(width);
    }

    public void doPut(int code) throws DviException {
        this.dp.drawChar(code);
    }

    public void doPutRule(int w, int h) throws DviException {
        this.dp.drawRule(w, h);
    }

    public void doNop() throws DviException {
    }

    public void doSelectFont(int fn) throws DviException {
        if (this.ctx.fs != null) {
            this.dp.endFont();
        }
        this.ctx.fs = (DviFontSpec)this.ft.get(fn);
        this.ctx.sm = this.getDviContext().findDviSimpleMetrics(this.ctx.fs);
        if (this.ctx.sm == null) {
            LOGGER.fine("No metric for font number " + fn + " font spec: " + this.ctx.fs);
        }
        this.dp.beginFont(this.ctx.fs);
    }

    public void doDefineFont(int fn, DviFontSpec fs) throws DviException {
    }

    public void doPush() throws DviException {
        this.ctx.stack.push((DviRegister)this.ctx.reg.clone());
    }

    public void doPop() throws DviException {
        if (this.ctx.stack.empty()) {
            throw new DviException("stack underflow.");
        }
        this.ctx.reg.copy((DviRegister)this.ctx.stack.pop());
    }

    public void doPre(DviPreamble preamble) throws DviException {
    }

    public void doBop(DviBop bop) throws DviException {
        this.ctx.reg.reset();
        this.ctx.stack.clear();
        this.dp.beginPage(bop);
    }

    public void doEop() throws DviException {
        this.dp.endPage();
    }

    public void doPost(DviPostamble postamble) throws DviException {
    }

    public void doPostPost(DviPostPost postPost) throws DviException {
        this.ctx.exe_ctx.setTerminate(true);
    }

    public void doRight(int by) throws DviException {
        this.ctx.reg.addH(by);
    }

    public void doW(int by) throws DviException {
        this.ctx.reg.setW(by);
        this.ctx.reg.addH(by);
    }

    public void doW0() throws DviException {
        this.ctx.reg.addH(this.ctx.reg.getW());
    }

    public void doX(int by) throws DviException {
        this.ctx.reg.setX(by);
        this.ctx.reg.addH(by);
    }

    public void doX0() throws DviException {
        this.ctx.reg.addH(this.ctx.reg.getX());
    }

    public void doDown(int by) throws DviException {
        this.ctx.reg.addV(by);
    }

    public void doY(int by) throws DviException {
        this.ctx.reg.setY(by);
        this.ctx.reg.addV(by);
    }

    public void doY0() throws DviException {
        this.ctx.reg.addV(this.ctx.reg.getY());
    }

    public void doZ(int by) throws DviException {
        this.ctx.reg.setZ(by);
        this.ctx.reg.addV(by);
    }

    public void doZ0() throws DviException {
        this.ctx.reg.addV(this.ctx.reg.getZ());
    }

    public void doSpecial(byte[] xxx) throws DviException {
        this.dp.drawSpecial(xxx);
    }

    private static final class GeometerContextImpl
    implements GeometerContext {
        private DviFontSpec fs = null;
        private SimpleMetrics sm = null;
        private final Stack<DviRegister> stack = new Stack();
        private DviRegister reg;
        private DviExecutorContext exe_ctx;

        private GeometerContextImpl() {
        }

        public DviFontSpec currentFontSpec() {
            return this.fs;
        }

        public DviRegister getRegister() {
            return this.reg;
        }

        public DviExecutorContext getExecuterContext() {
            return this.exe_ctx;
        }
    }
}

