/*
 * Decompiled with CFR 0.152.
 */
package dvi.plat.cygwin;

import dvi.util.CommandShell;
import dvi.util.DviUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CygwinUtils {
    private static final Logger LOGGER = Logger.getLogger(CygwinUtils.class.getName());

    public static String posixPathToJavaPath(String posixPath) throws IOException {
        CommandShell cs = new CommandShell();
        ArrayList<String> list = new ArrayList<String>();
        list.add("cygpath");
        list.add("-w");
        list.add(posixPath);
        cs.setCommandLine(list);
        final ArrayList outputs = new ArrayList();
        cs.setHandler(new CommandShell.Handler(){

            public void handleStderr(InputStream in) throws IOException {
                DviUtils.logLinesFromStream("cygpath stderr", in, LOGGER, Level.FINE);
            }

            public void handleStdout(InputStream in) throws IOException {
                String[] lines;
                for (String line : lines = DviUtils.readLinesFromStream(in)) {
                    outputs.add(line);
                }
            }
        });
        int ret = cs.execute();
        if (ret != 0) {
            LOGGER.warning("command failed: " + DviUtils.join(" ", list));
            return null;
        }
        if (outputs.size() > 0) {
            return (String)outputs.get(0);
        }
        return null;
    }
}

