/*
 * Decompiled with CFR 0.152.
 */
package dvi.gui.swing;

import dvi.DviColor;
import dvi.DviObject;
import dvi.DviPaperSize;
import dvi.DviResolution;
import dvi.api.DviContextSupport;
import dvi.api.GammaCorrector;
import dvi.render.DefaultGammaCorrector;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class ViewSpec
extends DviObject
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(ViewSpec.class.getName());
    protected EventListenerList listenerList = new EventListenerList();
    private DviColor backgroundColor = new DviColor(255, 255, 255);
    private int epsResolutionDpi = 200;
    private String epsImageFileExtension = ".jpg";
    private String epsImageDeviceName = "jpeg";
    private DviColor foregroundColor = new DviColor(0, 0, 0);
    private static final GammaCorrector defaultGammaCorrector = new DefaultGammaCorrector(1.4, 1.2);
    private GammaCorrector gammaCorrector = defaultGammaCorrector;
    private DviPaperSize paperSize;
    private boolean postScriptEnabled = true;
    private DviResolution res = new DviResolution(2400, 20);

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChangeEvent() {
        ChangeEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (event == null) {
                event = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public ViewSpec(DviContextSupport dcs) {
        super(dcs);
    }

    public Object clone() {
        try {
            ViewSpec vs = (ViewSpec)super.clone();
            vs.backgroundColor = this.backgroundColor;
            vs.epsResolutionDpi = this.epsResolutionDpi;
            vs.foregroundColor = this.foregroundColor;
            vs.gammaCorrector = this.gammaCorrector;
            vs.paperSize = this.paperSize;
            vs.postScriptEnabled = this.postScriptEnabled;
            vs.res = this.res;
            vs.epsImageDeviceName = this.epsImageDeviceName;
            vs.epsImageFileExtension = this.epsImageFileExtension;
            vs.epsResolutionDpi = this.epsResolutionDpi;
            return vs;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public DviColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getEpsResolutionDpi() {
        return this.epsResolutionDpi;
    }

    public DviColor getForegroundColor() {
        return this.foregroundColor;
    }

    public GammaCorrector getGammaCorrector() {
        return this.gammaCorrector;
    }

    public DviPaperSize getPaperSize() {
        return this.paperSize;
    }

    public DviResolution getResolution() {
        return this.res;
    }

    public boolean isPostScriptEnabled() {
        return this.postScriptEnabled;
    }

    public void setPostScriptEnabled(boolean postScriptEnabled) {
        this.postScriptEnabled = postScriptEnabled;
        this.fireChangeEvent();
    }

    public void setBackgroundColor(DviColor c) {
        this.backgroundColor = c;
        this.fireChangeEvent();
    }

    public void setEpsResolutionDpi(int epsResolutionDpi) {
        this.epsResolutionDpi = epsResolutionDpi;
        this.fireChangeEvent();
    }

    public void setForegroundColor(DviColor c) {
        this.foregroundColor = c;
        this.fireChangeEvent();
    }

    public void setGammaCorrector(GammaCorrector gc) {
        this.gammaCorrector = gc;
        this.fireChangeEvent();
    }

    public void setPaperSize(DviPaperSize paperSize) {
        this.paperSize = paperSize;
        this.fireChangeEvent();
    }

    public void setResolution(DviResolution res) {
        this.res = res;
        LOGGER.finer("res=" + res);
        this.fireChangeEvent();
    }

    public void setEpsImageFileExtension(String epsImageFileExtension) {
        this.epsImageFileExtension = epsImageFileExtension;
        this.fireChangeEvent();
    }

    public String getEpsImageFileExtension() {
        return this.epsImageFileExtension;
    }

    public void setEpsImageDeviceName(String epsImageDevice) {
        this.epsImageDeviceName = epsImageDevice;
        this.fireChangeEvent();
    }

    public String getEpsImageDeviceName() {
        return this.epsImageDeviceName;
    }

    public String toString() {
        return this.getClass().getName() + "[backgroundColor=" + this.backgroundColor + ",epsResolutionDpi=" + this.epsResolutionDpi + ",foregroundColor=" + this.foregroundColor + ",gammaCorrector=" + this.gammaCorrector + ",paperSize=" + this.paperSize + ",postScriptEnabled=" + this.postScriptEnabled + ",resolution=" + this.res + "]";
    }

    public void setApproximateDpi(double dpi) {
        this.setResolution(this.res.approximate(dpi));
    }

    public static GammaCorrector getDefaultGammaCorrector() {
        return defaultGammaCorrector;
    }
}

