/*
 * Decompiled with CFR 0.152.
 */
package dvi.gui.swing;

import dvi.DviException;
import dvi.api.DviContext;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.api.DviPage;
import dvi.gui.swing.DefaultDviLayoutManager;
import dvi.gui.swing.DviLayoutManager;
import dvi.gui.swing.TDviPage;
import dvi.gui.swing.ViewSpec;
import java.awt.FlowLayout;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TDviDocument
extends JPanel
implements DviContextSupport,
ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(TDviDocument.class.getName());
    private static final long serialVersionUID = -8289664311728401054L;
    private JPanel panel = new JPanel();
    private final ArrayList<TDviPage> pageList = new ArrayList();
    private ViewSpec viewSpec = new ViewSpec(this);
    private DviLayoutManager dviLayout = new DefaultDviLayoutManager(this, 1);
    private final DviContextSupport dcs;
    private boolean enableDelayedRendering = false;
    private DviDocument doc;

    public void setViewSpec(ViewSpec vs) throws DviException {
        if (this.viewSpec != null) {
            this.viewSpec.removeChangeListener(this);
        }
        this.viewSpec = vs;
        if (this.viewSpec != null) {
            this.viewSpec.addChangeListener(this);
        }
        this.reload();
    }

    public ViewSpec getViewSpec() {
        return this.viewSpec;
    }

    public DviContext getDviContext() {
        return this.dcs.getDviContext();
    }

    public TDviDocument(DviContextSupport dcs) {
        this.dcs = dcs;
        this.viewSpec.setResolution(this.viewSpec.getResolution().approximate(10.0));
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.setLayout(new FlowLayout());
        this.add(this.panel);
    }

    public void setDviDocument(DviDocument doc) throws DviException {
        LOGGER.fine("Preparaing TDviDocument with viewSpec=" + this.viewSpec);
        this.doc = doc;
        try {
            this.panel.removeAll();
            this.pageList.clear();
            LOGGER.finer("dvi document = " + doc);
            if (doc != null) {
                this.panel.setLayout(this.getDviLayout().createLayout(doc, this.viewSpec.getResolution()));
                for (DviPage page : doc.getPages()) {
                    int j;
                    LOGGER.fine("preparing TDviPage viewSpec=" + this.viewSpec);
                    TDviPage dp = new TDviPage(this);
                    dp.setViewSpec(this.viewSpec);
                    dp.setDviLayout(this.dviLayout);
                    dp.setPage(page);
                    this.getDviLayout().decoratePage(this, dp);
                    dp.setVisible(true);
                    dp.addChangeListener(new ChangeListener(){

                        public void stateChanged(ChangeEvent e) {
                            TDviDocument.this.fireChangeEvent();
                        }
                    });
                    MouseListener[] mls = this.getMouseListeners();
                    for (j = 0; j < mls.length; ++j) {
                        dp.addMouseListener(mls[j]);
                    }
                    MouseMotionListener[] mmls = this.getMouseMotionListeners();
                    for (j = 0; j < mmls.length; ++j) {
                        dp.addMouseMotionListener(mmls[j]);
                    }
                    this.panel.add(dp);
                    this.pageList.add(dp);
                }
            } else {
                LOGGER.finer("dvi document is null");
            }
        }
        catch (Exception ex) {
            LOGGER.severe(ex.toString());
        }
        this.revalidate();
        this.repaint();
    }

    public void reload() throws DviException {
        this.setDviDocument(this.doc);
    }

    public DviDocument getDviDocument() {
        return this.doc;
    }

    public DviLayoutManager getDviLayout() {
        return this.dviLayout;
    }

    public void setDviLayout(DviLayoutManager dviLayout) throws DviException {
        this.dviLayout = dviLayout;
        this.reload();
    }

    public void setEnableDelayedRendering(boolean enableDelayedRendering) {
        this.enableDelayedRendering = enableDelayedRendering;
    }

    public boolean getEnableDelayedRendering() {
        return this.enableDelayedRendering;
    }

    public void stateChanged(ChangeEvent e) {
        LOGGER.fine("stateChanged: EDT=" + SwingUtilities.isEventDispatchThread() + " viewSpec=" + this.viewSpec);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    TDviDocument.this.reload();
                }
                catch (DviException e) {
                    LOGGER.warning(e.toString());
                }
            }
        });
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChangeEvent() {
        ChangeEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (event == null) {
                event = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public boolean isBusy() {
        for (TDviPage dp : this.pageList) {
            if (!dp.isBusy()) continue;
            return true;
        }
        return false;
    }
}

