/*
 * Decompiled with CFR 0.152.
 */
package dvi.doc;

import dvi.DviException;
import dvi.DviFontTable;
import dvi.DviObject;
import dvi.DviUnit;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.api.DviInput;
import dvi.api.DviPage;
import dvi.api.HasURL;
import dvi.cmd.DviPostPost;
import dvi.cmd.DviPostamble;
import dvi.cmd.DviPreamble;
import dvi.doc.DefaultDviPage;
import dvi.doc.StreamDviDocument;
import dvi.util.DviUtils;
import java.io.IOException;
import java.net.URL;

public class URLDviDocument
extends DviObject
implements DviDocument,
HasURL {
    private final URL url;
    private final DviDocument streamDoc;

    public URLDviDocument(DviContextSupport dcs, URL url) throws DviException {
        super(dcs);
        this.url = url;
        try {
            this.streamDoc = new StreamDviDocument(this, url.openStream()){

                protected DviPage createPage(int pageNum, long bop, long eop) {
                    return new DefaultDviPage(URLDviDocument.this, pageNum, bop, eop);
                }
            };
        }
        catch (IOException e) {
            throw new DviException(e);
        }
    }

    public DviPage getPage(int p) throws DviException {
        return this.streamDoc.getPage(p);
    }

    public DviPage[] getPages() throws DviException {
        return this.streamDoc.getPages();
    }

    public DviPostPost getPostPost() throws DviException {
        return this.streamDoc.getPostPost();
    }

    public DviPostamble getPostamble() throws DviException {
        return this.streamDoc.getPostamble();
    }

    public DviPreamble getPreamble() throws DviException {
        return this.streamDoc.getPreamble();
    }

    public int getTotalPages() throws DviException {
        return this.streamDoc.getTotalPages();
    }

    public long getDataSize() throws DviException {
        return this.streamDoc.getDataSize();
    }

    public DviUnit getDviUnit() throws DviException {
        return this.streamDoc.getDviUnit();
    }

    public DviFontTable getFontTable() throws DviException {
        return this.streamDoc.getFontTable();
    }

    public DviInput getInput() throws DviException {
        return this.streamDoc.getInput();
    }

    public DviInput getInput(long start, long end) throws DviException {
        return this.streamDoc.getInput(start, end);
    }

    public String getCacheKey() {
        return this.getClass().getName() + "--" + DviUtils.md5Hex(this.url.toExternalForm()) + this.streamDoc.getCacheKey();
    }

    public URL getURL() throws DviException {
        return this.url;
    }
}

