/*
 * Decompiled with CFR 0.152.
 */
package dvi.doc;

import dvi.DviException;
import dvi.DviFontSpec;
import dvi.DviFontTable;
import dvi.DviObject;
import dvi.DviUnit;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.api.DviInput;
import dvi.api.DviPage;
import dvi.api.HasURL;
import dvi.cmd.DviPostPost;
import dvi.cmd.DviPostamble;
import dvi.cmd.DviPreamble;
import dvi.doc.DefaultDviPage;
import dvi.io.ByteArrayDviData;
import dvi.io.DviRandomAccessFileInput;
import dvi.render.EmptyHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class DirectFileDviDocument
extends DviObject
implements DviDocument,
HasURL {
    public static final long MAX_BUFFER_LENGTH = 10000000L;
    private final File file;
    private DviPreamble preamble = null;
    private DviPostamble postamble = null;
    private DviPostPost postPost = null;
    final DviFontTable fontTable = new DviFontTable();
    private ArrayList<DviPage> pages = new ArrayList();

    public DirectFileDviDocument(DviContextSupport dcs, File file) throws DviException {
        super(dcs);
        this.file = file;
        try {
            RandomAccessFile in = new RandomAccessFile(file, "r");
            this.parseRandomAccessFile(in);
            in.close();
        }
        catch (IOException ex) {
            throw new DviException(ex);
        }
    }

    private void parseRandomAccessFile(RandomAccessFile in) throws IOException, DviException {
        if (247 != in.readUnsignedByte()) {
            throw new DviException("Format error in dvi file: file doesn't start with pre.");
        }
        int idByte = in.readUnsignedByte();
        int num = in.readInt();
        int den = in.readInt();
        int mag = in.readInt();
        int k = in.readUnsignedByte();
        byte[] comment = new byte[k];
        in.readFully(comment);
        this.preamble = new DviPreamble(idByte, DviUnit.getInstance(num, den, mag), comment);
        long pos = in.length() - 1L;
        long paddingSize = 0L;
        while (true) {
            if (pos < 0L) {
                throw new DviException("Dvi file ended while looking for the postamble.");
            }
            in.seek(pos);
            if (223 != in.readUnsignedByte()) break;
            ++paddingSize;
            --pos;
        }
        if ((pos -= 5L) < 0L) {
            throw new DviException("Dvi file ended while looking for the postamble.");
        }
        long postPostPointer = pos;
        in.seek(pos);
        if (249 != in.readUnsignedByte()) {
            throw new DviException("Format error in dvi file: unable to find post_post.");
        }
        int postamblePointer = in.readInt();
        if (postamblePointer < 0 || (long)postamblePointer > in.length() - 33L) {
            throw new DviException("Format error in dvi file: file size too short.");
        }
        int idByte2 = in.readUnsignedByte();
        this.postPost = new DviPostPost(postamblePointer, idByte2);
        in.seek(this.postPost.postamblePointer());
        if (248 != in.readUnsignedByte()) {
            throw new DviException("Format error in dvi file: unable to find post.");
        }
        int bp = in.readInt();
        int num2 = in.readInt();
        int den2 = in.readInt();
        int mag2 = in.readInt();
        int maxV = in.readInt();
        int maxH = in.readInt();
        int maxStackDepth = in.readUnsignedShort();
        int totalPages = in.readUnsignedShort();
        this.postamble = new DviPostamble(bp, DviUnit.getInstance(num2, den2, mag2), maxV, maxH, maxStackDepth, totalPages);
        long buflen = postPostPointer - in.getFilePointer();
        if (0L < buflen) {
            if (buflen > 10000000L) {
                throw new DviException("Too long data after postamble.");
            }
            byte[] buf = new byte[(int)buflen];
            in.readFully(buf);
            this.getDviContext().execute(new ByteArrayDviData(buf), new EmptyHandler(){

                public void doDefineFont(int fn, DviFontSpec fs) {
                    DirectFileDviDocument.this.fontTable.put(fn, fs);
                }
            });
        }
        long bop = this.postamble.firstBackPointer();
        long eop = this.postPost.postamblePointer() - 1;
        int pageNum = this.postamble.totalPages();
        while (bop != -1L && pageNum > 0) {
            in.seek(bop);
            if (139 != in.readUnsignedByte()) {
                throw new DviException("Format error in dvi file: broken bop link.");
            }
            this.pages.add(0, new DefaultDviPage(this, --pageNum, bop, eop));
            eop = bop - 1L;
            in.seek(bop + 1L + 40L);
            bop = in.readInt();
        }
        if (pageNum != 0) {
            throw new DviException("Format error in dvi file: wrong number of pages.");
        }
    }

    public int getTotalPages() throws DviException {
        return this.postamble.totalPages();
    }

    public DviUnit getDviUnit() {
        return this.postamble.dviUnit();
    }

    public DviPreamble getPreamble() {
        return this.preamble;
    }

    public DviPostamble getPostamble() {
        return this.postamble;
    }

    public DviPostPost getPostPost() {
        return this.postPost;
    }

    public DviFontTable getFontTable() {
        return this.fontTable;
    }

    public DviInput getInput() throws DviException {
        try {
            RandomAccessFile raf = new RandomAccessFile(this.getFile(), "r");
            DviRandomAccessFileInput in = new DviRandomAccessFileInput(raf);
            return in;
        }
        catch (FileNotFoundException e) {
            throw new DviException(e);
        }
    }

    public DviInput getInput(long start, long end) throws DviException {
        try {
            RandomAccessFile raf = new RandomAccessFile(this.getFile(), "r");
            raf.seek(start);
            DviRandomAccessFileInput in = new DviRandomAccessFileInput(raf);
            in.setOffset(start);
            in.setEnd(end);
            return in;
        }
        catch (FileNotFoundException e) {
            throw new DviException(e);
        }
        catch (IOException e) {
            throw new DviException(e);
        }
    }

    public DviPage getPage(int p) throws DviException {
        if (p < 0 || this.getTotalPages() <= p) {
            throw new IllegalArgumentException("page number out of bounds.");
        }
        return this.pages.get(p);
    }

    public DviPage[] getPages() {
        return this.pages.toArray(new DviPage[0]);
    }

    public long getDataSize() throws DviException {
        return this.getFile().length();
    }

    public File getFile() {
        return this.file;
    }

    public URL getURL() throws DviException {
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException e) {
            throw new DviException(e);
        }
    }
}

