/*
 * Decompiled with CFR 0.152.
 */
package dvi.ctx;

import dvi.DviException;
import dvi.DviObject;
import dvi.api.DviContextSupport;
import dvi.plat.cygwin.CygwinUtils;
import dvi.util.CommandShell;
import dvi.util.DviUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KpseWhich
extends DviObject {
    private static final Logger LOGGER = Logger.getLogger(KpseWhich.class.getName());
    private static boolean available = false;
    private static volatile boolean availabilityChecked = false;
    private static boolean usingKpseWhichOfCygwin = false;

    public KpseWhich(DviContextSupport dcs) {
        super(dcs);
        if (!availabilityChecked) {
            this.checkAvailability();
        }
    }

    private static void setAvailability(boolean isAvailable) {
        available = isAvailable;
        availabilityChecked = true;
    }

    private synchronized void checkAvailability() {
        boolean success = true;
        try {
            String filename = "cmr10.mf";
            String result = this.findURLInternal(filename, true);
            if (result == null) {
                LOGGER.warning("Unable to locate by kpsewhich: " + filename);
                success = false;
            } else {
                LOGGER.info("kpsewhich answers: filename=" + filename + " result=" + result);
                File f = new File(result);
                if (!f.exists()) {
                    if (DviUtils.isWindows()) {
                        LOGGER.info("Trying cygpath to map " + result + " to system path.");
                        File f2 = this.fromPosixPath(result);
                        if (f2.exists()) {
                            LOGGER.info("The mapped path seems to work: " + f2.getAbsolutePath());
                            usingKpseWhichOfCygwin = true;
                            LOGGER.info("Using kpsewhich under cygwin.");
                            success = true;
                        } else {
                            LOGGER.warning("The mapped path does not work: " + f2.getAbsolutePath());
                            success = false;
                        }
                    } else {
                        LOGGER.warning("Unable to find file: " + result);
                        success = false;
                    }
                } else {
                    LOGGER.info("Using default kpsewhich.");
                    success = true;
                }
            }
        }
        catch (MalformedURLException ex) {
            success = false;
        }
        catch (DviException ex) {
            success = false;
        }
        catch (RuntimeException ex) {
            success = false;
        }
        KpseWhich.setAvailability(success);
        if (!success) {
            LOGGER.info("kpsewhich is not available");
        }
    }

    private File fromPosixPath(String posixPath) {
        try {
            String windowsPath = CygwinUtils.posixPathToJavaPath(posixPath);
            return new File(windowsPath);
        }
        catch (IOException e) {
            DviUtils.logStackTrace(LOGGER, Level.WARNING, e);
            return null;
        }
    }

    public URL findURL(String name) throws MalformedURLException, DviException {
        return this.findURL(name, false);
    }

    private String findURLInternal(String name, boolean mustExist) throws MalformedURLException, DviException {
        String result = null;
        try {
            Vector<String> cmdLine = new Vector<String>();
            cmdLine.add(this.getDviContext().getExecutableName("kpsewhich"));
            if (mustExist) {
                cmdLine.add("-must-exist");
            }
            cmdLine.add("-mktex=pk");
            cmdLine.add("-mktex=tex");
            cmdLine.add("-mktex=mf");
            cmdLine.add("-mktex=tfm");
            cmdLine.add("-dpi=600");
            cmdLine.add("-mode=ljfour");
            cmdLine.add(name);
            final ArrayList<String> stderrData = new ArrayList<String>();
            final ArrayList stdoutData = new ArrayList();
            CommandShell cs = new CommandShell();
            cs.setCommandLine(cmdLine);
            cs.setHandler(new CommandShell.Handler(){

                public void handleStderr(InputStream in) throws IOException {
                    DviUtils.addLinesFromStream(stderrData, in, LOGGER, Level.FINE, System.err);
                }

                public void handleStdout(InputStream in) throws IOException {
                    DviUtils.addLinesFromStream(stdoutData, in);
                }
            });
            int ret = cs.execute();
            if (ret != 0) {
                LOGGER.fine("kpsewhich command failed with retcode=" + ret + " cmdline=" + DviUtils.join(" ", cmdLine) + " stderr=" + DviUtils.join("\n", stderrData));
            } else if (stdoutData.size() > 0) {
                result = (String)stdoutData.get(0);
            }
        }
        catch (Exception e) {
            DviUtils.logStackTrace(LOGGER, Level.WARNING, e);
        }
        LOGGER.fine("kpsewhich result: name=" + name + " result=" + result);
        return result;
    }

    public URL findURL(String name, boolean mustExist) throws MalformedURLException, DviException {
        if (!available) {
            return null;
        }
        String path = this.findURLInternal(name, mustExist);
        if (path == null) {
            return null;
        }
        File file = null;
        file = usingKpseWhichOfCygwin ? this.fromPosixPath(path) : new File(path);
        if (mustExist && !file.exists()) {
            file = null;
        }
        if (file != null) {
            return file.toURL();
        }
        return null;
    }
}

