/*
 * Decompiled with CFR 0.152.
 */
package dvi.ctx;

import dvi.DviObject;
import dvi.api.DviContextSupport;
import dvi.ctx.KpseWhich;
import dvi.util.concurrent.Computation;
import dvi.util.progress.ProgressItem;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLocationResolver
extends DviObject
implements Computation<String, Collection<URL>> {
    private static final Logger LOGGER = Logger.getLogger(FileLocationResolver.class.getName());
    private final String systemResourcePath;
    private final String filename;

    public FileLocationResolver(DviContextSupport dcs, String systemResourcePath, String filename) {
        super(dcs);
        this.filename = filename;
        this.systemResourcePath = systemResourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<URL> call() throws Exception {
        ProgressItem progress = this.getDviContext().getProgressRecorder().open("preparing " + this.filename);
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            LOGGER.finer("running kpsewhich: " + this.filename);
            URL url = null;
            KpseWhich kpseWhich = new KpseWhich(this);
            url = kpseWhich.findURL(this.filename, true);
            LOGGER.finer("kpsewhich result: " + this.filename + " => " + url);
            if (url != null) {
                list.add(url);
            }
            URL u = ClassLoader.getSystemResource(this.systemResourcePath + "/" + this.filename);
            LOGGER.fine("system resource by kpsewhich: " + this.filename + " => " + u);
            if (u != null) {
                list.add(u);
            }
        }
        catch (RuntimeException e) {
            LOGGER.warning(e.toString());
        }
        finally {
            progress.close();
        }
        return list;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getCacheKey() {
        return this.filename;
    }

    public String getSystemResourcePath() {
        return this.systemResourcePath;
    }
}

