/*
 * Decompiled with CFR 0.152.
 */
package dvi.ctx;

import dvi.DviException;
import dvi.DviObject;
import dvi.DviPaperSize;
import dvi.DviRect;
import dvi.DviResolution;
import dvi.api.DevicePainter;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.api.DviPage;
import dvi.api.ImageDevice;
import dvi.gui.swing.ViewSpec;
import dvi.render.BasicGeometer;
import dvi.render.DviBoundingBoxPreparator;
import dvi.render.DviPagePreparator;
import dvi.render.IntRGBImage;
import dvi.render.RunLengthSampler;
import dvi.special.AnchorSet;
import dvi.special.DviImage;
import dvi.special.EPS2ImagePreparator;
import dvi.special.EmbeddedPostScript;
import dvi.special.EmbeddedPostScriptPreparator;
import dvi.special.HtmlSpecialParser;
import dvi.special.SourceSpecialParser;
import dvi.util.DviUtils;
import dvi.util.concurrent.CacheEntry;
import dvi.util.concurrent.CachedComputer;
import dvi.util.concurrent.ThreadedComputer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DviToolkit
extends DviObject {
    private static final Logger LOGGER = Logger.getLogger(DviToolkit.class.getName());
    private static final Map<String, AnchorSet> anchorSetCache = Collections.synchronizedMap(new LinkedHashMap<String, AnchorSet>(){
        private static final long serialVersionUID = 3603340224879882990L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, AnchorSet> entry) {
            return this.size() > 1024;
        }
    });
    private static final CachedComputer<String, DviRect> computerForBoundingBoxPreparator = new CachedComputer<String, DviRect>(new ThreadedComputer(1)){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CacheEntry<String, DviRect>> entry) {
            return this.getCache().size() > 1024;
        }
    };
    private static final boolean renderDebugInfo = false;
    private static final CachedComputer<String, Long> computerForPreparator = new CachedComputer<String, Long>(new ThreadedComputer(1)){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CacheEntry<String, Long>> entry) {
            return this.getCache().size() > 1024;
        }
    };
    private static final CachedComputer<String, EmbeddedPostScript> computerForEmbeddedPostScriptPreparator = new CachedComputer<String, EmbeddedPostScript>(new ThreadedComputer(1)){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CacheEntry<String, EmbeddedPostScript>> entry) {
            return this.getCache().size() > 1024;
        }
    };
    private static final CachedComputer<String, DviImage> computerForEPS2Image = new CachedComputer<String, DviImage>(new ThreadedComputer(1)){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CacheEntry<String, DviImage>> entry) {
            return this.getCache().size() > 10;
        }
    };

    public DviToolkit(DviContextSupport dcs) {
        super(dcs);
    }

    public DviRect computeRawBoundingBox(DviPage page, DviResolution res) throws DviException {
        DviRect bbox;
        if (page == null) {
            return null;
        }
        DviBoundingBoxPreparator computation = new DviBoundingBoxPreparator(this, page, res);
        Future<DviRect> future = computerForBoundingBoxPreparator.compute(computation);
        try {
            bbox = future.get();
        }
        catch (InterruptedException e) {
            throw new DviException(e);
        }
        catch (ExecutionException e) {
            throw new DviException(e);
        }
        return bbox;
    }

    public DviRect computeBoundingBox(DviPage page, DviResolution res) throws DviException {
        if (page == null) {
            return null;
        }
        DviRect bbox = this.computeRawBoundingBox(page, res);
        if (bbox == null) {
            return bbox;
        }
        return bbox.shrink(res.shrinkFactor());
    }

    public DviRect[] computeRawBoundingBoxes(DviDocument doc, DviResolution res) throws DviException {
        if (doc == null) {
            return null;
        }
        ArrayList<DviRect> bbox = new ArrayList<DviRect>();
        for (DviPage page : doc.getPages()) {
            bbox.add(this.computeRawBoundingBox(page, res));
        }
        return bbox.toArray(new DviRect[0]);
    }

    public DviRect[] computeBoundingBoxes(DviDocument doc, DviResolution res) throws DviException {
        if (doc == null) {
            return null;
        }
        DviRect[] raw = this.computeRawBoundingBoxes(doc, res);
        DviRect[] ret = new DviRect[raw.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = raw[i].shrink(res.shrinkFactor());
        }
        return ret;
    }

    private void drawNamedFrame(Graphics gg, String string, Color color, int x, int y, int width, int height) {
        gg.setColor(color);
        gg.drawString(string, x, y + 32);
        gg.drawRect(x, y, width - 1, height - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage renderToBufferedImage(BufferedImage img, int x, int y, DviPage page, DviRect rect, ViewSpec viewSpec) throws DviException {
        IntRGBImage rgbImage;
        int paper2dispY;
        int paper2dispX;
        DviResolution res;
        block11: {
            if (img == null) {
                throw new NullPointerException("img");
            }
            if (page == null) {
                throw new NullPointerException("page");
            }
            if (viewSpec == null) {
                throw new NullPointerException("view spec");
            }
            res = viewSpec.getResolution();
            DviRect paper = this.computePageBoundingBox(viewSpec.getPaperSize(), res);
            if (rect == null) {
                rect = paper;
            }
            paper2dispX = x - rect.x();
            paper2dispY = y - rect.y();
            WritableRaster raster = img.getRaster();
            DataBufferInt data = (DataBufferInt)raster.getDataBuffer();
            rgbImage = new IntRGBImage(data.getData(), raster.getWidth(), raster.getHeight());
            rgbImage.fill(viewSpec.getBackgroundColor().toIntRGB());
            if (viewSpec.isPostScriptEnabled()) {
                try {
                    DviImage dviImage = this.getEmbeddedPostScriptAsImage(page, viewSpec);
                    if (dviImage == null) break block11;
                    Graphics2D gg = img.createGraphics();
                    try {
                        Image bgImg = dviImage.getImage();
                        if (bgImg != null) {
                            double factor = res.actualDpi() / (double)dviImage.getDpi();
                            int sw = (int)((double)bgImg.getWidth(null) * factor);
                            int sh = (int)((double)bgImg.getHeight(null) * factor);
                            DviRect psRect = new DviRect(paper.bottomLeft().translate(0, -sh + 1), sw, sh);
                            gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                            gg.drawImage(bgImg, paper2dispX + psRect.x(), paper2dispY + psRect.y(), psRect.width(), psRect.height(), null);
                        }
                    }
                    finally {
                        gg.dispose();
                    }
                }
                catch (OutOfMemoryError e) {
                    DviUtils.logStackTrace(LOGGER, Level.SEVERE, e);
                }
            }
        }
        ImageDevice out = rgbImage.getImageDevice(res, viewSpec.getGammaCorrector());
        out.setColor(viewSpec.getForegroundColor());
        out.translate(paper2dispX, paper2dispY);
        DevicePainter dp = this.getDviContext().newDevicePainter();
        dp.setOutput(new RunLengthSampler(out));
        BasicGeometer geometer = new BasicGeometer(this);
        geometer.setPainter(dp);
        this.getDviContext().execute(page, geometer);
        return img;
    }

    public BufferedImage createCompatibleBufferedImage(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        return img;
    }

    public BufferedImage renderToBufferedImage(DviPage page, DviRect bbox, ViewSpec viewSpec) throws DviException {
        DviResolution res = viewSpec.getResolution();
        DviRect paper = this.computePageBoundingBox(viewSpec.getPaperSize(), res);
        if (bbox == null) {
            bbox = paper;
        }
        BufferedImage img = this.createCompatibleBufferedImage(bbox.width(), bbox.height());
        return this.renderToBufferedImage(img, 0, 0, page, bbox, viewSpec);
    }

    public void prepareForRendering(DviDocument doc, ViewSpec viewSpec) throws DviException {
        if (doc == null) {
            return;
        }
        if (doc.getTotalPages() > 0) {
            DviPage page = doc.getPage(0);
            this.prepareForRendering(page, viewSpec);
            this.computeBoundingBoxes(doc, viewSpec.getResolution());
        }
    }

    private AnchorSet buildAnchorSetForDocument(DviDocument doc) {
        DviObject hse;
        AnchorSet as = new AnchorSet();
        try {
            hse = new HtmlSpecialParser(this);
            ((HtmlSpecialParser)hse).execute(doc);
            LOGGER.fine("Extracted Html tags from " + doc);
            as.addAll(((HtmlSpecialParser)hse).getAnchorSet());
        }
        catch (DviException e) {
            LOGGER.warning(e.toString());
        }
        try {
            hse = new SourceSpecialParser(this);
            ((SourceSpecialParser)hse).execute(doc);
            LOGGER.fine("Extracted Source specials from " + doc);
            as.addAll(((SourceSpecialParser)hse).getAnchorSet());
        }
        catch (DviException e) {
            LOGGER.warning(e.toString());
        }
        return as;
    }

    public AnchorSet getAnchorSet(DviPage page) throws DviException {
        if (page == null) {
            return null;
        }
        DviDocument doc = page.getDocument();
        String key = doc.getCacheKey();
        AnchorSet as = anchorSetCache.get(key);
        if (as == null && (as = this.buildAnchorSetForDocument(doc)) != null) {
            anchorSetCache.put(key, as);
            LOGGER.fine("Cached AnchorSet with key " + key);
        }
        if (as == null) {
            return null;
        }
        AnchorSet pageAnchorSet = new AnchorSet();
        pageAnchorSet.addAll(as.intersect(page.range()));
        return pageAnchorSet;
    }

    public DviRect computePageBoundingBox(DviPaperSize paperSize, DviResolution res) {
        DviRect bbox = null;
        try {
            paperSize = this.getDviContext().getDefaultPaperSize();
        }
        catch (DviException e) {
            LOGGER.warning(e.toString());
        }
        if (paperSize == null) {
            LOGGER.warning("The default paper size is undefined. We use A4.");
            paperSize = new DviPaperSize(210.0, 297.0, "A4 internal");
        }
        bbox = paperSize.toBoundingBox(res);
        return bbox;
    }

    public void prepareForRendering(DviPage page, ViewSpec viewSpec) {
        DviPagePreparator computation = new DviPagePreparator(this, page, viewSpec);
        try {
            computerForPreparator.compute(computation).get();
        }
        catch (InterruptedException e) {
            DviUtils.logStackTrace(LOGGER, Level.WARNING, e);
        }
        catch (ExecutionException e) {
            DviUtils.logStackTrace(LOGGER, Level.SEVERE, e);
        }
    }

    public boolean canRenderPageImmediately(DviPage page, ViewSpec viewSpec) {
        DviPagePreparator computation = new DviPagePreparator(this, page, viewSpec);
        Future<Long> future = computerForPreparator.getCachedResult(computation);
        return future != null && future.isDone();
    }

    public EmbeddedPostScript getEmbeddedPostScript(DviDocument doc, ViewSpec viewSpec) throws DviException {
        EmbeddedPostScriptPreparator computation = new EmbeddedPostScriptPreparator(this, doc, viewSpec);
        Future<EmbeddedPostScript> future = computerForEmbeddedPostScriptPreparator.compute(computation);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw new DviException(e);
        }
        catch (ExecutionException e) {
            throw new DviException(e);
        }
    }

    public String getEmbeddedPostScript(DviPage page, ViewSpec viewSpec) throws DviException {
        if (page == null) {
            return null;
        }
        EmbeddedPostScript eps = this.getEmbeddedPostScript(page.getDocument(), viewSpec);
        return eps.toPostScript(page.getPageNumber(), viewSpec.getEpsResolutionDpi());
    }

    public DviImage getEmbeddedPostScriptAsImage(DviPage page, ViewSpec viewSpec) throws DviException {
        EPS2ImagePreparator computation = new EPS2ImagePreparator(this, page, viewSpec);
        Future<DviImage> future = computerForEPS2Image.compute(computation);
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw new DviException(e);
        }
        catch (ExecutionException e) {
            throw new DviException(e);
        }
    }

    public BufferedImage getScaledImage(int width, int height, BufferedImage image) {
        if (image == null) {
            return null;
        }
        int origWidth = image.getWidth();
        int origHeight = image.getHeight();
        if (width < 0) {
            width = origHeight > 0 ? origWidth * height / origHeight : 0;
        } else if (height < 0) {
            height = origWidth > 0 ? origHeight * width / origWidth : 0;
        }
        BufferedImage out = this.createCompatibleBufferedImage(width, height);
        Graphics2D g = out.createGraphics();
        g.drawImage(image.getScaledInstance(width, height, 4), null, null);
        g.dispose();
        return out;
    }
}

