/*
 * Decompiled with CFR 0.152.
 */
package dvi.util.concurrent;

import dvi.util.DaemonThreadFactory;
import dvi.util.concurrent.AbstractComputer;
import dvi.util.concurrent.Computation;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedComputer<K, V>
extends AbstractComputer<K, V> {
    private final ExecutorService executorService;

    public ThreadedComputer(int nThreads, ThreadFactory threadFactory) {
        if (threadFactory == null) {
            threadFactory = this.createThreadFactory();
        }
        this.executorService = this.createExecutorService(nThreads, threadFactory);
    }

    public ThreadedComputer(int nThreads) {
        this(nThreads, null);
    }

    protected ThreadFactory createThreadFactory() {
        return new DaemonThreadFactory(1);
    }

    protected ExecutorService createExecutorService(int nThreads, ThreadFactory threadFactory) {
        return Executors.newFixedThreadPool(nThreads, threadFactory);
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public ExecutorService getExecutorService(Computation<K, V> computable) {
        return this.executorService;
    }
}

