/*
 * Decompiled with CFR 0.152.
 */
package dvi.util.concurrent;

import dvi.util.concurrent.Computation;
import dvi.util.concurrent.Computer;
import java.util.concurrent.Future;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputerProgressMonitor<K, V>
implements Computer<K, V> {
    private static final Logger LOGGER = Logger.getLogger(ComputerProgressMonitor.class.getName());
    private final Computer<K, V> computer;

    public ComputerProgressMonitor(Computer<K, V> computer) {
        this.computer = computer;
    }

    @Override
    public Future<V> compute(final Computation<K, V> computation) {
        Computation wrapper = new Computation<K, V>(){

            @Override
            public V call() throws Exception {
                Object v;
                ComputerProgressMonitor.this.fireComputationBeginEvent(computation);
                try {
                    Object v2;
                    v = v2 = computation.call();
                    Object var4_4 = null;
                    ComputerProgressMonitor.this.fireComputationEndEvent(computation);
                }
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        ComputerProgressMonitor.this.fireComputationEndEvent(computation);
                        throw throwable;
                    }
                }
                return v;
            }

            @Override
            public K getCacheKey() {
                return computation.getCacheKey();
            }
        };
        return this.computer.compute(wrapper);
    }

    protected void fireComputationEndEvent(Computation<K, V> computation) {
        LOGGER.finer("computation ended: " + computation);
    }

    protected void fireComputationBeginEvent(Computation<K, V> computation) {
        LOGGER.finer("computation started: " + computation);
    }

    public Computer<K, V> getComputer() {
        return this.computer;
    }
}

