/*
 * Decompiled with CFR 0.152.
 */
package dvi.util.concurrent;

import dvi.util.concurrent.Computation;
import dvi.util.concurrent.Computer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComputer<K, V>
implements Computer<K, V> {
    private static final Logger LOGGER = Logger.getLogger(AbstractComputer.class.getName());

    public abstract ExecutorService getExecutorService(Computation<K, V> var1);

    @Override
    public Future<V> compute(Computation<K, V> computable) {
        ExecutorService exe = this.getExecutorService(computable);
        Future future = exe.submit(computable);
        LOGGER.finer("Scheduled computation " + computable + " to executor service " + exe + " with future object " + future);
        return future;
    }
}

