/*
 * Decompiled with CFR 0.152.
 */
package dvi.special;

import dvi.DviException;
import dvi.DviObject;
import dvi.DviUnit;
import dvi.api.DviContextSupport;
import dvi.util.DviUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedPostScript {
    private final Vector<Prologue> prologues = new Vector();
    private final Vector<Global> globals = new Vector();
    private final HashMap<Integer, Vector<Local>> page2locals = new HashMap();
    private Vector<Local> locals = null;

    public void beginPage(int pageNum) {
        if (this.page2locals.containsKey(pageNum)) {
            this.locals = this.page2locals.get(pageNum);
        } else {
            this.locals = new Vector();
            this.page2locals.put(pageNum, this.locals);
        }
    }

    public void endPage() {
        this.locals = null;
    }

    public void add(Prologue a) {
        this.prologues.add(a);
    }

    public void add(Global a) {
        this.globals.add(a);
    }

    public void add(Local a) {
        this.locals.add(a);
    }

    private static void writePostScript(Vector<? extends Element> ce, PrintWriter pw, Config cfg) throws DviException {
        for (Element element : ce) {
            element.writePostScript(pw, cfg);
        }
    }

    public String toPostScript(int pageNum, int dpi) throws DviException {
        if (!this.page2locals.containsKey(pageNum)) {
            return null;
        }
        Vector<Local> ls = this.page2locals.get(pageNum);
        if (ls == null || ls.size() == 0) {
            return null;
        }
        Config cfg = new Config(dpi);
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("%!PS-Adobe-2.0");
            pw.println("%%Pages: 1");
            pw.println("%%BoundingBox: 0 0 595 842");
            pw.println("%%EndComments");
            pw.println("%!");
            EmbeddedPostScript.writePostScript(this.prologues, pw, cfg);
            pw.println("TeXDict begin 39158280 55380996  1000 " + dpi + " " + dpi + " (a.dvi) " + " @start end ");
            pw.println("TeXDict begin 1 0 bop 0 0 a");
            EmbeddedPostScript.writePostScript(this.globals, pw, cfg);
            EmbeddedPostScript.writePostScript(ls, pw, cfg);
            pw.println("end");
            pw.println("showpage");
            pw.close();
            sw.flush();
            return sw.toString();
        }
        catch (Exception ex) {
            throw new DviException(ex);
        }
    }

    private static String escapeFilenameForPS(String s) {
        return s.replaceAll("\\\\", "\\\\\\\\");
    }

    public static class QuoteSpecial
    extends PSSpecial {
        public QuoteSpecial(int h, int v, DviUnit dviUnit, String postScript) {
            super(h, v, dviUnit, postScript);
        }

        public void writePostScript(PrintWriter pw, Config cfg) {
            super.writePostScript(pw, cfg);
            pw.println(" @beginspecial @setspecial " + this.postScript + " @endspecial");
        }
    }

    public static class PSSpecial
    extends WithReferencePoint {
        public final String postScript;

        public PSSpecial(int h, int v, DviUnit dviUnit, String postScript) {
            super(h, v, dviUnit);
            this.postScript = postScript;
        }

        public void writePostScript(PrintWriter pw, Config cfg) {
            super.writePostScript(pw, cfg);
            pw.println(" " + this.postScript);
        }
    }

    public static class PSFileSpecial
    extends WithReferencePoint {
        public final String fileName;
        public final int llx;
        public final int lly;
        public final int urx;
        public final int ury;
        public final int rwi;
        public final int rhi;
        public final int angle;

        public PSFileSpecial(int h, int v, DviUnit dviUnit, String fileName, int llx, int lly, int urx, int ury, int rwi, int rhi, int angle) {
            super(h, v, dviUnit);
            this.fileName = fileName;
            this.llx = llx;
            this.lly = lly;
            this.urx = urx;
            this.ury = ury;
            this.rwi = rwi;
            this.rhi = rhi;
            this.angle = angle;
        }

        public void writePostScript(PrintWriter pw, Config cfg) {
            super.writePostScript(pw, cfg);
            String escapedFilename = EmbeddedPostScript.escapeFilenameForPS(this.fileName);
            pw.println(" @beginspecial " + this.llx + " @llx" + " " + this.lly + " @lly" + " " + this.urx + " @urx" + " " + this.ury + " @ury" + (this.rwi != 0 ? " " + this.rwi + " @rwi" : "") + (this.rhi != 0 ? " " + this.rhi + " @rhi" : "") + (this.angle != 0 ? " " + this.angle + " @angle" : "") + " @setspecial" + " (" + escapedFilename + ") run" + " @endspecial");
        }
    }

    private static class WithReferencePoint
    implements Local {
        public final int h;
        public final int v;
        public final DviUnit dviUnit;

        private WithReferencePoint(int h, int v, DviUnit dviUnit) {
            this.h = h;
            this.v = v;
            this.dviUnit = dviUnit;
        }

        public void writePostScript(PrintWriter pw, Config cfg) {
            double psH = this.dviUnit.mapToPixelDouble(this.h, cfg.dpi);
            double psV = this.dviUnit.mapToPixelDouble(this.v, cfg.dpi);
            pw.println(" " + psH + " " + psV + " moveto ");
        }
    }

    public static class BangSpecial
    implements Global {
        public final String postScript;

        public BangSpecial(String postScript) {
            this.postScript = postScript;
        }

        public void writePostScript(PrintWriter pw, Config cfg) {
            pw.println(" @defspecial " + this.postScript + " @fedspecial");
        }
    }

    public static class HeaderSpecial
    implements Global {
        public final String fileName;

        public HeaderSpecial(String fileName) {
            this.fileName = fileName;
        }

        public void writePostScript(PrintWriter pw, Config cfg) {
            String escapedFilename = EmbeddedPostScript.escapeFilenameForPS(this.fileName);
            pw.println(" (" + escapedFilename + ") run");
        }
    }

    public static class PrologueFile
    extends DviObject
    implements Prologue {
        public final String fileName;

        public PrologueFile(DviContextSupport dcs, String fileName) {
            super(dcs);
            this.fileName = fileName;
        }

        public void writePostScript(PrintWriter pw, Config cfg) throws DviException {
            File file = DviUtils.toLocalFile(this.getDviContext().getDviResource(this.fileName));
            if (file == null || !file.exists()) {
                throw new DviException("Cannot find postscript prologue: " + this.fileName);
            }
            String escapedFilename = EmbeddedPostScript.escapeFilenameForPS(file.getAbsolutePath());
            pw.println(" (" + escapedFilename + ") run");
        }
    }

    public static class ProloguePostScript {
        public final String postScript;

        public ProloguePostScript(String postScript) {
            this.postScript = postScript;
        }

        public void writePostScript(PrintWriter pw, Config cfg) {
            pw.println(this.postScript);
        }
    }

    public static interface Prologue
    extends Element {
    }

    public static interface Global
    extends Element {
    }

    public static interface Local
    extends Element {
    }

    private static interface Element {
        public void writePostScript(PrintWriter var1, Config var2) throws DviException;
    }

    private static class Config {
        public final int dpi;

        private Config(int dpi) {
            this.dpi = dpi;
        }
    }
}

