/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.DviObject;
import dvi.DviRect;
import dvi.DviResolution;
import dvi.api.DviContextSupport;
import dvi.api.DviPage;
import dvi.render.BasicGeometer;
import dvi.render.BoundingBoxComputer;
import dvi.render.DefaultDevicePainter;
import dvi.util.concurrent.Computation;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DviBoundingBoxPreparator
extends DviObject
implements Computation<String, DviRect> {
    private static final Logger LOGGER = Logger.getLogger(DviBoundingBoxPreparator.class.getName());
    private final DviPage page;
    private final DviResolution res;

    public DviBoundingBoxPreparator(DviContextSupport dcs, DviPage page, DviResolution res) {
        super(dcs);
        this.page = page;
        this.res = res;
    }

    @Override
    public DviRect call() throws Exception {
        BoundingBoxComputer bbc = new BoundingBoxComputer(this.res);
        DefaultDevicePainter dp = new DefaultDevicePainter(this);
        dp.setEnableCharBoundingBox(true);
        dp.setEnableCharRendering(false);
        dp.setOutput(bbc);
        BasicGeometer geometer = new BasicGeometer(this);
        geometer.setPainter(dp);
        this.getDviContext().execute(this.page, geometer);
        DviRect bbox = bbc.getBoundingBox();
        LOGGER.finer("bounding box=" + bbox + " resolution=" + this.res + " page=" + this.page);
        return bbox;
    }

    @Override
    public String getCacheKey() {
        String key = this.page.getCacheKey() + "-" + this.res.dpi();
        return key;
    }
}

