/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.api.GammaCorrector;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultGammaCorrector
implements GammaCorrector {
    private static final AtomicLong serializer = new AtomicLong();
    private final double factor;
    private final double exponent;
    private final long serial;

    public DefaultGammaCorrector() {
        this(1.0, 1.0);
    }

    public DefaultGammaCorrector(double factor, double exponent) {
        this.factor = factor;
        this.exponent = exponent;
        this.serial = serializer.incrementAndGet();
    }

    public double factor() {
        return this.factor;
    }

    public double exponent() {
        return this.exponent;
    }

    public int correctGamma(int c, int maxval) {
        return (int)(1024.0 * Math.min(1.0, Math.pow(this.factor * (double)c / (double)maxval, this.exponent)) + 0.5);
    }

    public int hashCode() {
        return (int)(33.0 * (this.factor + 33.0 * this.exponent));
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultGammaCorrector)) {
            return false;
        }
        DefaultGammaCorrector gc = (DefaultGammaCorrector)o;
        return this.factor == gc.factor && this.exponent == gc.exponent;
    }

    public String getCacheKey() {
        return this.getClass().getName() + "--" + this.serial;
    }

    public String toString() {
        return this.getClass().getName() + "[factor=" + this.factor + ",exponent=" + this.exponent + "]";
    }
}

