/*
 * Decompiled with CFR 0.152.
 */
package dvi.render;

import dvi.DviByteRange;
import dvi.DviColor;
import dvi.DviException;
import dvi.DviFontSpec;
import dvi.DviObject;
import dvi.DviRegister;
import dvi.DviResolution;
import dvi.DviUnit;
import dvi.api.BinaryDevice;
import dvi.api.DevicePainter;
import dvi.api.DviContextSupport;
import dvi.api.DviData;
import dvi.api.DviFont;
import dvi.api.DviPage;
import dvi.api.FullMetrics;
import dvi.api.GeometerContext;
import dvi.api.Glyph;
import dvi.cmd.DviBop;
import dvi.ctx.DviToolkit;
import dvi.font.LogicalFont;
import dvi.special.Anchor;
import dvi.special.AnchorSet;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultDevicePainter
extends DviObject
implements DevicePainter {
    private static final Logger LOGGER = Logger.getLogger(DefaultDevicePainter.class.getName());
    private BinaryDevice out = null;
    private DviColor defaultColor;
    private GeometerContext geom_ctx = null;
    private DviUnit dviUnit = null;
    private DviResolution res = null;
    private double factor;
    private AnchorSet anchors = null;
    private LogicalFont lf = null;
    private boolean fontResolved = false;
    private DviFont font = null;
    private boolean enableCharRendering = true;
    private boolean enableCharBoundingBox = false;
    private final Stack<DviColor> colorStack = new Stack();
    private static final Pattern pushPat = Pattern.compile("color\\s+push\\s+(.*)", 2);
    private static final Pattern popPat = Pattern.compile("color\\s+pop", 2);
    private static final Pattern colorPat = Pattern.compile("color\\s+(.*)", 2);
    private DviColor specialColor = DviColor.INVALID;
    private DviColor anchorColor = DviColor.INVALID;

    public DefaultDevicePainter(DviContextSupport dcs) {
        super(dcs);
    }

    public void setOutput(BinaryDevice out) throws DviException {
        this.out = out;
        this.defaultColor = out.getColor();
    }

    public BinaryDevice getOutput() {
        return this.out;
    }

    protected GeometerContext getGeometerContext() {
        return this.geom_ctx;
    }

    protected DviUnit getDviUnit() {
        return this.dviUnit;
    }

    public void begin(GeometerContext ctx) throws DviException {
        this.geom_ctx = ctx;
        this.dviUnit = this.geom_ctx.getExecuterContext().getData().getDviUnit();
        this.res = this.out.getResolution();
        this.out.begin();
        this.out.translate(this.res.dpi(), this.res.dpi());
        this.factor = this.dviUnit.factorDouble(this.res.dpi());
    }

    public void end() throws DviException {
        this.out.end();
        this.res = null;
        this.dviUnit = null;
        this.geom_ctx = null;
    }

    public void beginPage(DviBop bop) throws DviException {
        DviToolkit utils = this.getDviContext().getDviToolkit();
        DviData data = this.geom_ctx.getExecuterContext().getData();
        if (data instanceof DviPage) {
            this.anchors = utils.getAnchorSet((DviPage)data);
            LOGGER.finer("anchors=" + this.anchors);
        }
    }

    public void endPage() throws DviException {
        this.anchors = null;
    }

    protected LogicalFont getLogicalFont() {
        return this.lf;
    }

    protected DviFont getFont() {
        return this.font;
    }

    public void beginFont(DviFontSpec fs) throws DviException {
        this.lf = LogicalFont.getInstance(fs, this.dviUnit, this.res);
        this.fontResolved = false;
        this.font = null;
    }

    public void endFont() throws DviException {
        this.fontResolved = false;
        this.font = null;
        this.lf = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawRectInternal(int ax, int ay, int ex, int ey) throws DviException {
        this.out.save();
        try {
            this.out.translate(ax, ay);
            this.realDrawRule(ex - ax + 1, ey - ay + 1);
        }
        finally {
            this.out.restore();
        }
    }

    protected void drawCharBoundingBox(int code) throws DviException {
        DviRegister reg = this.geom_ctx.getRegister();
        DviFontSpec fs = this.lf.fontSpec();
        FullMetrics fm = this.getDviContext().findDviFullMetrics(fs);
        if (fm != null) {
            int width = fs.tfmToDvi(fm.getTfmWidth(code));
            int height = fs.tfmToDvi(fm.getTfmHeight(code));
            int depth = fs.tfmToDvi(fm.getTfmDepth(code));
            int ax_sf = (int)(this.factor * (double)reg.getH() + 0.5);
            int ex_sf = (int)(this.factor * (double)(reg.getH() + width - 1) + 0.5);
            int ay_sf = (int)(this.factor * (double)(reg.getV() - height + 1) + 0.5);
            int ey_sf = (int)(this.factor * (double)(reg.getV() + depth - 1) + 0.5);
            int by_sf = (int)(this.factor * (double)reg.getV() + 0.5);
            this.drawRectInternal(ax_sf, ay_sf, ex_sf, ay_sf);
            this.drawRectInternal(ax_sf, ey_sf, ex_sf, ey_sf);
            this.drawRectInternal(ax_sf, ay_sf, ax_sf, ey_sf);
            this.drawRectInternal(ex_sf, ay_sf, ex_sf, ey_sf);
            this.drawRectInternal(ax_sf, by_sf, ex_sf, by_sf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawChar(int code) throws DviException {
        this.handleAnchors();
        if (this.getEnableCharRendering()) {
            DviRegister reg = this.geom_ctx.getRegister();
            int rx_sf = (int)(this.factor * (double)reg.getH() + 0.5);
            int ry_sf = (int)(this.factor * (double)reg.getV() + 0.5);
            this.out.save();
            try {
                this.out.translate(rx_sf, ry_sf);
                this.realDrawChar(this.lf, code);
            }
            finally {
                this.out.restore();
            }
        }
        if (this.getEnableCharBoundingBox()) {
            this.drawCharBoundingBox(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveFont() {
        if (!this.fontResolved) {
            try {
                this.font = this.getDviContext().findDviFont(this.lf);
            }
            catch (DviException ex) {
                ex.printStackTrace();
                this.font = null;
            }
            finally {
                this.fontResolved = true;
            }
        }
    }

    protected void realDrawChar(LogicalFont lf, int code) throws DviException {
        this.resolveFont();
        if (this.font == null) {
            return;
        }
        this.determineColor(this.out);
        Glyph g = this.font.getGlyph(lf, code);
        if (g != null) {
            g.rasterizeTo(this.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRule(int width, int height) throws DviException {
        this.handleAnchors();
        if (width <= 0 || height <= 0) {
            return;
        }
        DviRegister reg = this.geom_ctx.getRegister();
        int ax_sf = (int)(this.factor * (double)reg.getH() + 0.5);
        int ex_sf = (int)(this.factor * (double)(reg.getH() + width - 1) + 0.5);
        int ay_sf = (int)(this.factor * (double)(reg.getV() - height + 1) + 0.5);
        int ey_sf = (int)(this.factor * (double)reg.getV() + 0.5);
        this.out.save();
        try {
            this.out.translate(ax_sf, ay_sf);
            this.realDrawRule(ex_sf - ax_sf + 1, ey_sf - ay_sf + 1);
        }
        finally {
            this.out.restore();
        }
    }

    protected void realDrawRule(int w_sf, int h_sf) throws DviException {
        if (this.out.beginRaster(w_sf, h_sf)) {
            this.determineColor(this.out);
            this.out.beginLine();
            this.out.putBits(w_sf, true);
            this.out.endLine(h_sf);
        }
        this.out.endRaster();
    }

    public void drawSpecial(byte[] _xxx) throws DviException {
        this.handleAnchors();
        String xxx = new String(_xxx);
        Matcher mat = pushPat.matcher(xxx);
        if (mat.matches()) {
            DviColor aColor = DviColor.parseColor(mat.group(1));
            this.colorStack.push(this.out.getColor());
            this.specialColor = aColor;
        } else {
            mat = popPat.matcher(xxx);
            if (mat.matches()) {
                if (this.colorStack.empty()) {
                    throw new IllegalStateException("Color stack underflow");
                }
                this.specialColor = this.colorStack.pop();
            } else {
                mat = colorPat.matcher(xxx);
                if (mat.matches()) {
                    DviColor aColor;
                    this.specialColor = aColor = DviColor.parseColor(mat.group(1));
                }
            }
        }
    }

    private void handleAnchors() throws DviException {
        if (this.anchors == null || this.anchors.size() == 0) {
            return;
        }
        LOGGER.finer("Rendering Anchor" + this.anchors);
        long begin = this.geom_ctx.getExecuterContext().getCommandRange().begin();
        this.anchorColor = DviColor.INVALID;
        for (DviByteRange br : this.anchors) {
            if (!br.contains(begin) || !(br instanceof Anchor.Href)) continue;
            this.anchorColor = DviColor.parseColor("blue");
        }
    }

    private void determineColor(BinaryDevice out) throws DviException {
        if (this.anchorColor.isValid()) {
            out.setColor(this.anchorColor);
        } else if (this.specialColor.isValid()) {
            out.setColor(this.specialColor);
        } else {
            out.setColor(this.defaultColor);
        }
    }

    public void setEnableCharRendering(boolean enableCharRendering) {
        this.enableCharRendering = enableCharRendering;
    }

    public boolean getEnableCharRendering() {
        return this.enableCharRendering;
    }

    public void setEnableCharBoundingBox(boolean enableCharBoundingBox) {
        this.enableCharBoundingBox = enableCharBoundingBox;
    }

    public boolean getEnableCharBoundingBox() {
        return this.enableCharBoundingBox;
    }
}

