/*
 * Decompiled with CFR 0.152.
 */
package dvi.io;

import dvi.DviException;
import dvi.DviFontTable;
import dvi.DviUnit;
import dvi.api.DviData;
import dvi.api.DviInput;
import dvi.io.DviInputStreamReader;
import java.io.ByteArrayInputStream;

public class ByteArrayDviData
implements DviData {
    private final byte[] buf;
    private final DviFontTable fontTable;
    private final DviUnit dviUnit;

    public ByteArrayDviData(byte[] buf) {
        this(buf, null, null);
    }

    public ByteArrayDviData(byte[] buf, DviUnit dviUnit) {
        this(buf, dviUnit, null);
    }

    public ByteArrayDviData(byte[] buf, DviUnit dviUnit, DviFontTable fontTable) {
        this.buf = buf;
        this.dviUnit = dviUnit;
        this.fontTable = fontTable;
        if (buf == null) {
            throw new IllegalArgumentException("dvi data buffer cannot be null");
        }
    }

    public DviInput getInput() {
        return new DviInputStreamReader(new ByteArrayInputStream(this.buf));
    }

    public DviFontTable getFontTable() {
        return this.fontTable;
    }

    public DviUnit getDviUnit() {
        return this.dviUnit;
    }

    public long getDataSize() throws DviException {
        return this.buf.length;
    }

    public DviInput getInput(long start, long end) throws DviException {
        if (start < 0L || end < 0L || end < start) {
            throw new IllegalArgumentException(String.format("Invalid byte range: (%d,%d)", start, end));
        }
        if (start >= (long)this.buf.length) {
            throw new IllegalArgumentException("start position out of bounds: " + start);
        }
        if (end >= (long)this.buf.length) {
            throw new IllegalArgumentException("end position out of bounds: " + end);
        }
        DviInputStreamReader in = new DviInputStreamReader(new ByteArrayInputStream(this.buf, (int)start, (int)(end - start) + 1));
        in.setOffset(start);
        return in;
    }
}

