/*
 * Decompiled with CFR 0.152.
 */
package dvi.image;

import dvi.util.DviUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PnmHeader {
    private static final Logger LOGGER = Logger.getLogger(PnmHeader.class.getName());
    public static final String PNM_COMMENT_NEWLINE = "\n";
    public static final int PNM_TYPE_BITMAP_ASCII = 1;
    public static final int PNM_TYPE_GRAYMAP_ASCII = 2;
    public static final int PNM_TYPE_PIXMAP_ASCII = 3;
    public static final int PNM_TYPE_BITMAP_BINARY = 4;
    public static final int PNM_TYPE_GRAYMAP_BINARY = 5;
    public static final int PNM_TYPE_PIXMAP_BINARY = 6;
    private final int type;
    private final int width;
    private final int height;
    private final int maxval;
    private final String comment;
    private static final Pattern patPnmComment = Pattern.compile("#\\s?(.*)");
    private static final Pattern patPnmSize = Pattern.compile("([0-9][0-9]*)\\s\\s*([0-9][0-9]*)");

    public PnmHeader(int type, String comment, int width, int height, int maxval) {
        this.type = type;
        this.comment = comment;
        this.width = width;
        this.height = height;
        this.maxval = maxval;
    }

    public boolean isBitmap() {
        return 1 == this.type || 4 == this.type;
    }

    public boolean isGraymap() {
        return 2 == this.type || 5 == this.type;
    }

    public boolean isPixmap() {
        return 3 == this.type || 6 == this.type;
    }

    public boolean isASCII() {
        return 1 <= this.type && this.type <= 3;
    }

    public boolean isBinary() {
        return !this.isASCII();
    }

    public int getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxValue() {
        return this.maxval;
    }

    public String toString() {
        return this.getClass().getName() + "[type=" + this.type + ",width=" + this.width + ",height=" + this.height + ",maxval=" + this.maxval + ",comment=" + this.comment + "]";
    }

    public String readLine(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        int c = -1;
        while ((c = is.read()) != 10) {
        }
        return sb.toString();
    }

    public static String readLine(InputStream is, int c, int delim) throws IOException {
        String line = "";
        do {
            if (c >= 0) {
                line = line + (char)c;
            }
            if ((c = is.read()) >= 0) continue;
            return null;
        } while (c != delim);
        return line;
    }

    public static PnmHeader parseHeader(InputStream is) throws IOException {
        Matcher mat;
        int type = -1;
        int width = -1;
        int height = -1;
        int maxval = -1;
        String comment = null;
        int c1 = is.read();
        int c2 = is.read();
        if (c1 != 80 || 49 > c2 || c2 > 54) {
            throw new IOException("Invalid PNM magic number: c1=" + (char)c1 + " c2=" + (char)c2);
        }
        type = c2 - 48;
        int c = -1;
        int delim = -1;
        c = is.read();
        while (PnmHeader.isNewLine(c)) {
            delim = c;
            c = is.read();
        }
        if (delim < 0) {
            throw new IOException("Illegal data after PNM magic number: " + c);
        }
        String line = PnmHeader.readLine(is, c, delim);
        while (null != line && (mat = patPnmComment.matcher(line)).matches()) {
            String s = mat.group(1);
            comment = comment == null ? s : comment + PNM_COMMENT_NEWLINE + s;
            line = PnmHeader.readLine(is, -1, delim);
        }
        Matcher mat2 = patPnmSize.matcher(line);
        if (mat2.matches()) {
            try {
                width = Integer.parseInt(mat2.group(1));
                height = Integer.parseInt(mat2.group(2));
            }
            catch (NumberFormatException e) {
                DviUtils.logStackTrace(LOGGER, Level.WARNING, e);
            }
        }
        if (width < 0 || height < 0) {
            throw new IOException("Failed to decode PNM image size: " + line);
        }
        if (1 == type || 4 == type) {
            maxval = 1;
        } else {
            line = PnmHeader.readLine(is, -1, delim);
            try {
                maxval = Integer.parseInt(line);
            }
            catch (NumberFormatException e) {
                DviUtils.logStackTrace(LOGGER, Level.WARNING, e);
            }
            if (maxval < 0) {
                throw new IOException("Failed to decode PNM max value: " + line);
            }
        }
        return new PnmHeader(type, comment, width, height, maxval);
    }

    private static boolean isNewLine(int c) {
        return c == 13 || c == 10;
    }

    public String getComment() {
        return this.comment;
    }
}

