/*
 * Decompiled with CFR 0.152.
 */
package dvi.gui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TexLogViewer
extends JPanel {
    private static final long serialVersionUID = 7630772409309800485L;
    private final JScrollPane scroll;
    private final JTextArea textArea;
    private boolean hasError = false;
    private File dviFile;

    public TexLogViewer(int rows, int cols) {
        this.setDviFile(null);
        this.textArea = new JTextArea(rows, cols);
        this.textArea.setOpaque(true);
        this.textArea.setEditable(false);
        this.scroll = new JScrollPane(this.textArea);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroll, "Center");
    }

    public File getDviFile() {
        return this.dviFile;
    }

    public void setDviFile(File dviFile) {
        this.dviFile = dviFile;
        this.setupView();
    }

    private File getLogFile() {
        String filename = this.dviFile.getPath();
        String filenameBase = filename.replaceFirst("\\.[_a-zA-Z0-9]*$", "");
        File logFile = new File(filenameBase + ".log");
        return logFile;
    }

    private void setupView() {
        this.hasError = false;
        if (this.dviFile == null) {
            return;
        }
        File logFile = this.getLogFile();
        boolean success = true;
        if (logFile.exists()) {
            StringBuilder sb = new StringBuilder();
            String extraInfo = "";
            try {
                Scanner s = new Scanner(logFile);
                while (s.hasNextLine()) {
                    String line = s.nextLine();
                    sb.append(line);
                    if (0 == line.indexOf("! Emergency stop.")) {
                        success = false;
                        Pattern pat = Pattern.compile("^l.([0-9]*) (.*)$");
                        while (s.hasNextLine()) {
                            line = s.nextLine();
                            sb.append(line);
                            Matcher mat = pat.matcher(line);
                            if (!mat.matches()) continue;
                            extraInfo = line;
                            break;
                        }
                    }
                    sb.append("\n");
                }
                s.close();
                sb.append("---[FOUND ERRORS]---\n");
                sb.append(extraInfo + "\n");
                this.textArea.setText(sb.toString());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (success) {
            this.textArea.setBackground(null);
        } else {
            this.textArea.setBackground(new Color(255, 204, 96));
        }
        this.hasError = !success;
    }

    public boolean hasError() {
        return this.hasError;
    }
}

