/*
 * Decompiled with CFR 0.152.
 */
package dvi.gui.swing;

import dvi.DviException;
import dvi.DviObject;
import dvi.DviPaperSize;
import dvi.DviRect;
import dvi.DviResolution;
import dvi.api.DviContextSupport;
import dvi.api.DviDocument;
import dvi.api.DviPage;
import dvi.ctx.DviToolkit;
import dvi.gui.swing.DviLayoutManager;
import dvi.gui.swing.TDviDocument;
import dvi.gui.swing.TDviPage;
import dvi.gui.swing.ViewSpec;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.logging.Logger;
import javax.swing.BorderFactory;

public class DefaultDviLayoutManager
extends DviObject
implements DviLayoutManager {
    private static final Logger LOGGER = Logger.getLogger(DefaultDviLayoutManager.class.getName());
    private int cols;
    private int horizontalSpacing;
    private int verticalSpacing;
    private int paddingSize;
    private DviPaperSize paperSize;
    private boolean crop;
    private boolean enableDelayedRendering = true;

    public DefaultDviLayoutManager(DviContextSupport dcs, int cols, int paddingSize) {
        super(dcs);
        this.setNumberOfColumns(cols);
        this.setPaddingSize(paddingSize);
    }

    public DefaultDviLayoutManager(DviContextSupport dcs, int cols) {
        this(dcs, cols, 0);
    }

    private int computeRows(DviDocument doc) throws DviException {
        int rows = (doc.getTotalPages() + this.cols - 1) / this.cols;
        return rows;
    }

    public LayoutManager createLayout(DviDocument doc, DviResolution res) throws DviException {
        return new GridLayout(this.computeRows(doc), this.cols, this.horizontalSpacing, this.verticalSpacing);
    }

    public DviRect getPageBoundingBox(DviDocument doc, DviResolution res) throws DviException {
        DviToolkit utils = this.getDviContext().getDviToolkit();
        if (this.getEnableCrop()) {
            DviRect bbox = DviRect.union(utils.computeBoundingBoxes(doc, res));
            return bbox;
        }
        DviPaperSize ps = null;
        try {
            ps = this.getDviContext().getDefaultPaperSize();
        }
        catch (DviException e) {
            LOGGER.warning(e.toString());
        }
        return utils.computePageBoundingBox(ps, res);
    }

    public DviRect getBoundingBox(DviDocument doc, DviResolution res) throws DviException {
        int rows = this.computeRows(doc);
        DviRect bbox = this.getPageBoundingBox(doc, res);
        DviRect ret = new DviRect(0, 0, bbox.width() * this.cols + this.horizontalSpacing * (this.cols - 1) + this.paddingSize * (this.cols + 1) + 16 * this.cols, bbox.height() * rows + this.verticalSpacing * (rows - 1) + this.paddingSize * (rows + 1) + 16 * this.cols);
        return ret;
    }

    public int getNumberOfColumns() {
        return this.cols;
    }

    public void setNumberOfColumns(int cols) {
        this.cols = Math.max(0, cols);
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        this.horizontalSpacing = horizontalSpacing;
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(int verticalSpacing) {
        this.verticalSpacing = verticalSpacing;
    }

    public void decoratePage(TDviDocument tdd, TDviPage dp) throws DviException {
        dp.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(190, 190, 190)));
    }

    public int getPaddingSize() {
        return this.paddingSize;
    }

    public void setPaddingSize(int paddingSize) {
        this.paddingSize = paddingSize;
    }

    public void setPaperSize(DviPaperSize paperSize) {
        this.paperSize = paperSize;
    }

    public DviPaperSize getPaperSize() {
        return this.paperSize;
    }

    public void setEnableCrop(boolean crop) {
        this.crop = crop;
    }

    public boolean getEnableCrop() {
        return this.crop;
    }

    public boolean getEnableDelayedRendering(TDviPage dp) throws DviException {
        return this.enableDelayedRendering;
    }

    public void setEnableDelayedRendering(boolean enableDelayedRendering) {
        this.enableDelayedRendering = enableDelayedRendering;
    }

    public DviRect determinePageSize(TDviPage dp) throws DviException {
        DviRect bbox = null;
        DviPage page = dp.getPage();
        ViewSpec viewSpec = dp.getViewSpec();
        DviResolution res = viewSpec.getResolution();
        if (page != null) {
            bbox = this.getPageBoundingBox(page.getDocument(), res);
        }
        if (bbox == null) {
            DviToolkit utils = this.getDviContext().getDviToolkit();
            bbox = utils.computePageBoundingBox(viewSpec.getPaperSize(), res);
        }
        return bbox.addPadding(this.paddingSize);
    }
}

