/*
 * Decompiled with CFR 0.152.
 */
package dvi.font;

import dvi.DviException;
import dvi.DviRect;
import dvi.api.BinaryDevice;
import dvi.api.DviInput;
import dvi.api.Glyph;
import dvi.font.PackedGlyphRasterizer;
import dvi.font.RunLengthEncodedGlyph;
import java.io.IOException;

public class PkGlyph
implements Glyph {
    private static final long serialVersionUID = 3825743583018783073L;
    public static final PkGlyph EMPTY = new PkGlyph(0, 0, null, 0, false, 0, 0);
    private int flagByte;
    private int dynF;
    private boolean turnOn;
    private int packetLength;
    private int code;
    private int tfmw;
    private byte[] raster = null;
    private int xAdvance;
    private int yAdvance;
    private int width;
    private int height;
    private int xOffset;
    private int yOffset;
    private DviRect bbox;

    private PkGlyph() {
    }

    public PkGlyph(int width, int height, byte[] raster, int dynF, boolean turnOn, int xOffset, int yOffset) {
        this.width = width;
        this.height = height;
        this.raster = raster;
        this.dynF = dynF;
        this.turnOn = turnOn;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.bbox = new DviRect(-xOffset, -yOffset, width, height);
        this.flagByte = 7;
        this.packetLength = 0;
        this.code = 0;
        this.tfmw = 0;
        this.yAdvance = 0;
        this.xAdvance = 0;
    }

    public static Glyph readFromInput(DviInput in) throws DviException, IOException {
        return PkGlyph.readFromInput(in.readU1(), in);
    }

    public static Glyph readFromInput(int firstByte, DviInput in) throws DviException, IOException {
        int rasterSize;
        PkGlyph g = new PkGlyph();
        g.flagByte = firstByte & 7;
        g.turnOn = 0 != (firstByte & 8);
        g.dynF = firstByte >> 4 & 0xF;
        if (g.flagByte == 7) {
            g.packetLength = in.readS4();
            g.code = in.readS4();
            g.tfmw = in.readS4();
            g.xAdvance = in.readS4();
            g.yAdvance = in.readS4();
            g.width = in.readS4();
            g.height = in.readS4();
            g.xOffset = in.readS4();
            g.yOffset = in.readS4();
            g.packetLength += 9;
            rasterSize = g.packetLength - 37;
        } else if (g.flagByte > 3) {
            g.packetLength = (g.flagByte - 4) * 65536 + in.readU2();
            g.code = in.readU1();
            g.tfmw = in.readS3();
            g.xAdvance = in.readU2() * 65536;
            g.yAdvance = 0;
            g.width = in.readU2();
            g.height = in.readU2();
            g.xOffset = in.readS2();
            g.yOffset = in.readS2();
            g.packetLength += 4;
            rasterSize = g.packetLength - 17;
        } else {
            g.packetLength = g.flagByte * 256 + in.readU1();
            g.code = in.readU1();
            g.tfmw = in.readS3();
            g.xAdvance = in.readU1() * 65536;
            g.yAdvance = 0;
            g.width = in.readU1();
            g.height = in.readU1();
            g.xOffset = in.readS1();
            g.yOffset = in.readS1();
            g.packetLength += 3;
            rasterSize = g.packetLength - 11;
        }
        if (rasterSize > 0) {
            g.raster = new byte[rasterSize];
            in.readFully(g.raster);
        } else if (rasterSize != 0) {
            throw new DviException("Negative rasterSize: " + rasterSize);
        }
        g.bbox = new DviRect(-g.xOffset, -g.yOffset, g.width, g.height);
        return g;
    }

    public boolean rasterByBits() {
        return this.dynF == 14;
    }

    public int flagByte() {
        return this.flagByte;
    }

    public int dynF() {
        return this.dynF;
    }

    public boolean turnOn() {
        return this.turnOn;
    }

    public int packetLength() {
        return this.packetLength;
    }

    public byte[] raster() {
        return this.raster;
    }

    public int code() {
        return this.code;
    }

    public int getTfmWidth() {
        return this.tfmw;
    }

    public int xAdvance() {
        return this.xAdvance;
    }

    public int yAdvance() {
        return this.yAdvance;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int xOffset() {
        return this.xOffset;
    }

    public int yOffset() {
        return this.yOffset;
    }

    public DviRect bounds() {
        return this.bbox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rasterizeTo(BinaryDevice out) throws DviException {
        out.save();
        try {
            out.translate(-this.xOffset, -this.yOffset);
            if (this.rasterByBits()) {
                RunLengthEncodedGlyph rlg = RunLengthEncodedGlyph.readRasterByBits(this.raster, this.width, this.height, 0, 0);
                rlg.rasterizeTo(out);
            } else {
                PackedGlyphRasterizer sub = new PackedGlyphRasterizer();
                sub.begin(this);
                sub.rasterizeTo(out);
                sub.end();
            }
        }
        finally {
            out.restore();
        }
    }

    public String toString() {
        return this.getClass().getName() + "[packetLength=" + this.packetLength + ",flagByte=" + this.flagByte + ",dynF=" + this.dynF + ",code=" + this.code + ",tfmw=" + this.tfmw + ",xAdvance=" + this.xAdvance + ",yAdvance=" + this.yAdvance + ",width=" + this.width + ",height=" + this.height + ",xOffset=" + this.xOffset + ",yOffset=" + this.yOffset + (this.raster != null ? ",rasterSize=" + this.raster.length : ",raster=null") + "]";
    }
}

