/*
 * Decompiled with CFR 0.152.
 */
package dvi.font;

import dvi.DviException;
import dvi.DviFontSpec;
import dvi.DviObject;
import dvi.DviResolution;
import dvi.DviUnit;
import dvi.api.DviContextSupport;
import dvi.api.DviFont;
import dvi.api.Glyph;
import dvi.api.SimpleMetrics;
import dvi.font.LogicalFont;
import dvi.font.PkGlyph;
import dvi.io.DviInputStreamReader;
import dvi.util.DviUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class PkFont
extends DviObject
implements DviFont,
SimpleMetrics {
    private static final long serialVersionUID = 1531160169076910099L;
    private final File file;
    private int idByte;
    private byte[] comment;
    private int designSize;
    private int checkSum;
    private int hppp;
    private int vppp;
    private long bodyOffset;
    private int numChars;
    private HashMap<Integer, Glyph> glyphs = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PkFont(DviContextSupport dcs, File file) throws DviException {
        super(dcs);
        this.file = file;
        try {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                this.parseInputStream(fis);
            }
            catch (Throwable throwable) {
                DviUtils.silentClose(fis);
                throw throwable;
            }
            DviUtils.silentClose(fis);
        }
        catch (DviException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DviException(ex);
        }
    }

    public PkFont(DviContextSupport dcs, InputStream is) throws DviException {
        super(dcs);
        try {
            this.parseInputStream(is);
        }
        catch (DviException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new DviException(ex);
        }
        this.file = null;
    }

    public boolean hasChar(int code) {
        return this.glyphs.containsKey(code);
    }

    public Glyph getGlyph(LogicalFont lf, int code) {
        return this.glyphs.get(code);
    }

    public int getWidth(int code) {
        PkGlyph g = (PkGlyph)this.glyphs.get(code);
        if (g == null) {
            return 0;
        }
        return g.width();
    }

    public int getHeight(int code) {
        PkGlyph g = (PkGlyph)this.glyphs.get(code);
        if (g == null) {
            return 0;
        }
        return g.height();
    }

    public int getTfmWidth(int code) {
        PkGlyph g = (PkGlyph)this.glyphs.get(code);
        if (g == null) {
            return 0;
        }
        return g.getTfmWidth();
    }

    public int getIdByte() {
        return this.idByte;
    }

    public byte[] getComment() {
        return (byte[])this.comment.clone();
    }

    public int getDesignSize() {
        return this.designSize;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public int getHppp() {
        return this.hppp;
    }

    public int getVppp() {
        return this.vppp;
    }

    public long getBodyOffset() {
        return this.bodyOffset;
    }

    public int getNumChars() {
        return this.numChars;
    }

    public void parseInputStream(InputStream is) throws IOException, DviException {
        DviInputStreamReader in = new DviInputStreamReader(new BufferedInputStream(is, 8192));
        if (in.readU1() != 247) {
            throw new DviException("PK file doesn't start with PRE.");
        }
        this.idByte = in.readU1();
        if (this.idByte != 89) {
            throw new DviException("Unrecognized PK file: wrong idByte: " + this.idByte);
        }
        int commentLen = in.readU1();
        this.comment = new byte[commentLen];
        in.readFully(this.comment);
        this.designSize = in.readS4();
        this.checkSum = in.readS4();
        this.hppp = in.readS4();
        this.vppp = in.readS4();
        this.bodyOffset = in.getOffset();
        this.numChars = 0;
        boolean stop = false;
        block7: while (!stop) {
            int c = in.readU1();
            switch (c) {
                case 240: 
                case 241: 
                case 242: 
                case 243: {
                    int len = in.readU(c - 240 + 1);
                    byte[] buf = new byte[len];
                    in.readFully(buf);
                    continue block7;
                }
                case 244: {
                    in.readS4();
                    continue block7;
                }
                case 246: {
                    continue block7;
                }
                case 245: {
                    stop = true;
                    continue block7;
                }
                case 247: {
                    throw new DviException("broken PK file: PRE found in the body of PK file: " + this.file.getPath());
                }
            }
            PkGlyph g = (PkGlyph)PkGlyph.readFromInput(c, in);
            this.glyphs.put(g.code(), g);
        }
    }

    public static String getDviResourceName(LogicalFont lf) {
        DviFontSpec fs = lf.fontSpec();
        DviResolution res = lf.resolution();
        DviUnit dviUnit = lf.dviUnit();
        int useDpi = (int)((double)res.dpi() * (double)fs.spaceSize() * (double)dviUnit.magnification() / (double)fs.designSize() / 1000.0);
        if (useDpi <= 0) {
            return null;
        }
        String pk = fs.name() + "." + useDpi + "pk";
        return pk;
    }
}

