/*
 * Decompiled with CFR 0.152.
 */
package dvi.event;

import dvi.event.TEvent;
import dvi.event.TEventListener;
import dvi.event.TEventModel;
import dvi.event.TEventMulticaster;
import dvi.event.TEventProcessor;

public class TDefaultEventModel
implements TEventModel {
    private volatile TEventListener listeners = null;

    public void addListener(TEventListener l) {
        this.listeners = TEventMulticaster.add(this.listeners, l);
    }

    public void addUniqueListener(TEventListener l) {
        this.removeListener(l);
        this.addListener(l);
    }

    public String dumpListeners() {
        if (this.listeners instanceof TEventMulticaster) {
            return ((TEventMulticaster)this.listeners).toString();
        }
        if (this.listeners == null) {
            return "null";
        }
        return this.listeners.toString();
    }

    public void removeListener(TEventListener l) {
        this.listeners = TEventMulticaster.remove(this.listeners, l);
    }

    public void removeListeners() {
        this.listeners = null;
    }

    public TEventListener getListeners() {
        return this.listeners;
    }

    public void inheritListeners(TEventProcessor ep) {
        if (ep == null) {
            return;
        }
        TEventModel em = ep.getEventModel();
        if (em == null) {
            return;
        }
        this.addListener(em.getListeners());
    }

    public void processEvent(TEvent e) {
        if (this.listeners != null) {
            this.listeners.handleEvent(e);
        }
    }
}

