/*
 * Decompiled with CFR 0.152.
 */
package dvi.ctx;

import dvi.DviException;
import dvi.DviObject;
import dvi.api.DviContextSupport;
import dvi.util.DviUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Logger;

public class KpseWhich
extends DviObject {
    private static final Logger LOGGER = Logger.getLogger(KpseWhich.class.getName());
    private String result = null;
    private static boolean available = false;
    private static boolean availabilityChecked = false;
    private Process p = null;

    public KpseWhich(DviContextSupport dcs) {
        super(dcs);
        if (!availabilityChecked) {
            this.checkAvailability();
        }
    }

    private void checkAvailability() {
        available = true;
        try {
            URL url = this.findURL("cmr10.mf", true);
            if (url == null) {
                available = false;
            }
        }
        catch (Exception ex) {
            available = false;
        }
        if (!available) {
            LOGGER.info("kpsewhich is not available");
        }
        availabilityChecked = true;
    }

    public URL findURL(String name) throws MalformedURLException, DviException {
        return this.findURL(name, false);
    }

    public URL findURL(String name, boolean mustExist) throws MalformedURLException, DviException {
        if (!available) {
            return null;
        }
        Vector<String> cmdLine = new Vector<String>();
        cmdLine.add(this.getDviContext().getExecutableName("kpsewhich"));
        if (mustExist) {
            cmdLine.add("-must-exist");
        }
        cmdLine.add("-mktex=pk");
        cmdLine.add("-mktex=tex");
        cmdLine.add("-mktex=mf");
        cmdLine.add("-mktex=tfm");
        cmdLine.add("-dpi=600");
        cmdLine.add("-mode=ljfour");
        cmdLine.add(name);
        this.work(cmdLine.toArray(new String[cmdLine.size()]));
        LOGGER.fine("kpsewhich result: name=" + name + " result=" + this.result);
        if (this.result == null) {
            return null;
        }
        File file = new File(this.result);
        if (mustExist && !file.exists()) {
            file = null;
        }
        if (file != null) {
            return file.toURL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void work(String[] cmdLine) {
        try {
            this.p = Runtime.getRuntime().exec(cmdLine, null, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        try {
            this.p.getOutputStream().close();
            DviUtils.dumpStreamAsync("kpsewhich stderr", this.p.getErrorStream(), null);
            this.handleInputStream(this.p.getInputStream());
            this.p.getInputStream().close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                this.p.waitFor();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.p = null;
    }

    public void handleInputStream(InputStream in) {
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            this.result = null;
            while (null != (line = r.readLine())) {
                this.result = line;
            }
            r.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

