/*
 * Decompiled with CFR 0.152.
 */
package dvi;

import dvi.DviRect;
import dvi.DviResolution;
import java.io.Serializable;

public class DviPaperSize
implements Serializable {
    private static final long serialVersionUID = 4593375448502371177L;
    public static final DviPaperSize UNBOUNDED = new DviPaperSize(Double.MAX_VALUE, Double.MAX_VALUE, "unbounded");
    public static final DviPaperSize CROP_TO_WIDTH = new DviPaperSize(Double.MAX_VALUE, Double.MAX_VALUE, "crop-to-width");
    public static final DviPaperSize CROP_TO_HEIGHT = new DviPaperSize(Double.MAX_VALUE, Double.MAX_VALUE, "crop-to-height");
    public static final DviPaperSize CROP_TO_BOTH = new DviPaperSize(Double.MAX_VALUE, Double.MAX_VALUE, "crop-to-both");
    private final double w_mm;
    private final double h_mm;
    private final String desc;

    public DviPaperSize(double w_mm, double h_mm, String desc) {
        this.w_mm = w_mm;
        this.h_mm = h_mm;
        this.desc = desc;
    }

    public double widthInMM() {
        return this.w_mm;
    }

    public double heightInMM() {
        return this.h_mm;
    }

    public int widthInDots(DviResolution res) {
        return (int)Math.ceil(res.actualDpi() * this.w_mm / 25.4);
    }

    public int heightInDots(DviResolution res) {
        return (int)Math.ceil(res.actualDpi() * this.h_mm / 25.4);
    }

    public DviRect toBoundingBox(DviResolution res) {
        return new DviRect(0, 0, this.widthInDots(res), this.heightInDots(res));
    }

    public String description() {
        return this.desc;
    }

    public String toString() {
        return "PaperSize{" + this.w_mm + "mm x " + this.h_mm + " mm" + " desc=" + this.desc;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DviPaperSize) {
            DviPaperSize a = (DviPaperSize)obj;
            return a.w_mm == this.w_mm && a.h_mm == this.h_mm && this.desc.equals(a.desc);
        }
        return false;
    }

    public int hashCode() {
        return (int)((double)this.desc.hashCode() + 33.0 * (this.w_mm + 33.0 * this.h_mm));
    }
}

