/*
 * Decompiled with CFR 0.152.
 */
package dvi.browser;

import dvi.api.DviContext;
import dvi.api.DviContextSupport;
import dvi.util.progress.ProgressEvent;
import dvi.util.progress.ProgressItem;
import dvi.util.progress.ProgressListener;
import dvi.util.progress.ProgressReporter;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class DviProgressView
extends JLabel
implements DviContextSupport,
ProgressListener {
    private static final Logger LOGGER = Logger.getLogger(DviProgressView.class.getName());
    private static final long serialVersionUID = -7549779069712448783L;
    private ProgressReporter reporter;
    private DviContextSupport dcs;

    public DviProgressView(DviContextSupport dcs) {
        this.dcs = dcs;
    }

    public DviContext getDviContext() {
        return this.dcs.getDviContext();
    }

    protected void update(ProgressItem item) {
        if (item != null) {
            final String text = item.toString();
            LOGGER.finer("Schedule message: " + text);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DviProgressView.this.setText(text);
                    LOGGER.finer("Set progress message: " + text);
                }
            });
        }
    }

    protected void update() {
        ProgressReporter reporter = this.getProgressReporter();
        if (reporter != null) {
            this.update(reporter.getMostRecentItem());
        }
    }

    public void progressClose(ProgressEvent e) {
        this.update(e.getItem());
    }

    public void progressOpen(ProgressEvent e) {
        this.update(e.getItem());
    }

    public void progressUpdate(ProgressEvent e) {
        this.update(e.getItem());
    }

    public void setProgressReporter(ProgressReporter reporter) {
        if (this.reporter != null) {
            this.reporter.removeProgressListener((ProgressListener)this);
        }
        this.reporter = reporter;
        if (this.reporter != null) {
            this.reporter.addProgressListener((ProgressListener)this);
        }
        this.update();
    }

    public ProgressReporter getProgressReporter() {
        return this.reporter;
    }
}

