/*
 * Decompiled with CFR 0.152.
 */
package dvi.browser;

import dvi.util.DviUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.lang.reflect.InvocationTargetException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DviLoadIndicator
implements Icon {
    private static final Logger LOGGER = Logger.getLogger(DviLoadIndicator.class.getName());
    private final EventListenerList listenerList = new EventListenerList();
    private int period = 16;
    private int count = 0;
    private TimerTask task;
    private final Timer timer = new Timer();

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public void fireUpdateEvent() {
        ChangeEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (event == null) {
                event = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public synchronized void start() {
        if (this.task != null) {
            LOGGER.fine("Load indicator already started.");
            return;
        }
        this.task = new TimerTask(){

            public void run() {
                DviLoadIndicator.this.increment();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            DviLoadIndicator.this.fireUpdateEvent();
                        }
                    });
                }
                catch (InterruptedException e) {
                    DviUtils.logStackTrace((Logger)LOGGER, (Level)Level.WARNING, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    DviUtils.logStackTrace((Logger)LOGGER, (Level)Level.WARNING, (Throwable)e);
                }
            }
        };
        this.timer.scheduleAtFixedRate(this.task, 0L, 100L);
        this.fireUpdateEvent();
    }

    public synchronized boolean isActive() {
        return this.task != null;
    }

    public synchronized void stop() {
        if (this.task == null) {
            return;
        }
        this.task.cancel();
        this.task = null;
        this.fireUpdateEvent();
    }

    protected synchronized void increment() {
        ++this.count;
    }

    public int getIconHeight() {
        return 16;
    }

    public int getIconWidth() {
        return 16;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.isActive()) {
            double r = 6.0;
            int N = 32;
            for (int i = 0; i < N; ++i) {
                double theta = Math.PI * 2 * (double)(this.count * N + i * 8) / (double)(this.period * N);
                int f = i * 255 / N;
                float h = (float)f / 2550.0f * 2.0f + 0.5f;
                float s = (float)f / 255.0f;
                float b = 0.99f;
                s = 1.0f - (float)Math.pow(s, 3.0);
                Color col = Color.getHSBColor(h, s, b);
                this.drawRadial(g, col, x + 2, y + 2, theta, r);
            }
        } else {
            g.drawRoundRect(x, y, 15, 15, 1, 1);
        }
    }

    public void drawRadial(Graphics g, Color c, int x, int y, double theta, double r) {
        double dx = Math.cos(theta);
        double dy = Math.sin(theta);
        g.setColor(c);
        g.drawLine((int)((double)x + r * (1.0 - dx)), (int)((double)y + r * (1.0 - dy)), (int)((double)x + r * (1.0 + dx)), (int)((double)y + r * (1.0 + dy)));
    }
}

