/*
 * Decompiled with CFR 0.152.
 */
package dvi.util;

import dvi.DviException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DviInfoDumper {
    private final Config conf;

    public DviInfoDumper(Config conf) {
        this.conf = conf;
    }

    public void execute() throws DviException {
        try {
            System.out.printf("mode=%s\n", this.conf.mode);
            for (String a : this.conf.plainArgs) {
                System.out.printf("arg: %s\n", a);
            }
        }
        catch (Exception ex) {
            throw new DviException(ex);
        }
    }

    public static class Config {
        private String mode = "help";
        private ArrayList<String> plainArgs = new ArrayList();
        private static Option[] options = new Option[]{new Option("--help", "-h", null, "Show this help"), new Option("--mode", "-m", "mode", "Set mode to <mode>")};
        private static final Pattern patShortOption = Pattern.compile("^(-[0-9a-zA-Z])(.*)$");
        private static final Pattern patLongOption = Pattern.compile("^(--[a-zA-Z][a-zA-Z0-9]*)(=(.*))?$");

        public void setMode(String mode) {
            this.mode = mode.toLowerCase();
        }

        public void addPlainArgument(String a) {
            this.plainArgs.add(a);
        }

        public static Config parseCommandLine(String[] args) throws DviException {
            String a;
            ArgumentList al = new ArgumentList(args);
            Config conf = new Config();
            while (null != (a = al.next())) {
                if (a.startsWith("-")) {
                    String v;
                    String a2;
                    boolean handled = false;
                    Matcher mat = patLongOption.matcher(a);
                    if (mat.find()) {
                        a2 = mat.group(1);
                        v = mat.group(3);
                        System.out.println("found long option: " + a2 + "=>" + v);
                        for (Option opt : options) {
                            if (!a2.equals(opt.longOpt)) continue;
                            handled = true;
                            if (opt.numArgs > 0) {
                                if (v == null) {
                                    throw new DviException("no value for option `" + a2 + "'");
                                }
                            } else if (v != null) {
                                throw new DviException("option `" + a2 + "' does not take argument");
                            }
                            break;
                        }
                    } else {
                        mat = patShortOption.matcher(a);
                        if (mat.find()) {
                            a2 = mat.group(1);
                            v = mat.group(3);
                            System.out.println("found short option: " + a2 + "=>" + v);
                            for (Option opt : options) {
                                if (!a.equals(opt.shortOpt)) continue;
                                handled = true;
                                break;
                            }
                        }
                    }
                    if (handled) continue;
                    throw new DviException("unrecognized option: " + a);
                }
                conf.addPlainArgument(a);
            }
            return conf;
        }
    }

    public static class Option {
        private final String longOpt;
        private final String shortOpt;
        private final int numArgs;
        private final String var;
        private final String description;

        public Option(String longOpt, String shortOpt, String var, String description) {
            this.longOpt = longOpt;
            this.shortOpt = shortOpt;
            this.var = var;
            this.numArgs = var != null ? 1 : 0;
            this.description = description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArgumentList
    extends LinkedList<String> {
        private static final long serialVersionUID = -9222800531977990881L;

        public ArgumentList(String[] args) {
            for (String a : args) {
                this.add(a);
            }
        }

        public String next() {
            if (this.size() == 0) {
                return null;
            }
            return (String)this.removeFirst();
        }
    }
}

