/*
 * Decompiled with CFR 0.152.
 */
package dvi.util;

import dvi.util.DviUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandShell {
    private static final Logger LOGGER = Logger.getLogger(CommandShell.class.getName());
    private String[] commandLine = null;
    private String[] envp = null;
    private File dir = null;
    private Handler handler = null;
    private volatile Process p = null;
    private Thread stdoutThread = null;
    private Thread stderrThread = null;

    public void setCommandLine(String[] commandLine) {
        this.commandLine = (String[])commandLine.clone();
    }

    public void setCommandLine(Collection<String> cmdLine) {
        this.setCommandLine(cmdLine.toArray(new String[cmdLine.size()]));
    }

    public void setEnvironment(Collection<String> envp) {
        this.setEnvironment(envp.toArray(new String[envp.size()]));
    }

    public void setEnvironment(String[] envp) {
        this.envp = (String[])envp.clone();
    }

    public void setWorkingDirectory(File dir) {
        this.dir = dir;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    protected void checkVars() {
        if (this.commandLine == null) {
            throw new IllegalArgumentException("commandLine can't be null");
        }
        if (this.commandLine.length < 1) {
            throw new IllegalArgumentException("commandLine can't be empty");
        }
    }

    /*
     * Loose catch block
     */
    public int execute() throws IOException {
        int result;
        block13: {
            result = -1;
            this.p = null;
            this.checkVars();
            this.p = Runtime.getRuntime().exec(this.commandLine, this.envp, this.dir);
            this.processStreams();
            Object var4_4 = null;
            try {
                LOGGER.fine("waiting for the stderr thread");
                if (this.stderrThread != null) {
                    this.stderrThread.join();
                }
                this.stderrThread = null;
                LOGGER.fine("waiting for the stdout thread");
                if (this.stdoutThread != null) {
                    this.stdoutThread.join();
                }
                this.stdoutThread = null;
                LOGGER.fine("waiting for the process to terminate.");
                this.p.waitFor();
                result = this.p.exitValue();
                LOGGER.fine("process exit with retcode " + result);
            }
            catch (InterruptedException ex) {
                DviUtils.logStackTrace(LOGGER, Level.WARNING, ex);
            }
            break block13;
            {
                catch (IOException ex) {
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    LOGGER.fine("waiting for the stderr thread");
                    if (this.stderrThread != null) {
                        this.stderrThread.join();
                    }
                    this.stderrThread = null;
                    LOGGER.fine("waiting for the stdout thread");
                    if (this.stdoutThread != null) {
                        this.stdoutThread.join();
                    }
                    this.stdoutThread = null;
                    LOGGER.fine("waiting for the process to terminate.");
                    this.p.waitFor();
                    result = this.p.exitValue();
                    LOGGER.fine("process exit with retcode " + result);
                }
                catch (InterruptedException ex) {
                    DviUtils.logStackTrace(LOGGER, Level.WARNING, ex);
                }
                throw throwable;
            }
        }
        this.p = null;
        return result;
    }

    protected void processStreams() throws IOException {
        this.p.getOutputStream().close();
        if (this.handler != null) {
            this.stderrThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    InputStream is = CommandShell.this.p.getErrorStream();
                    try {
                        CommandShell.this.handler.handleStderr(is);
                    }
                    catch (Exception ex) {
                        DviUtils.logStackTrace(LOGGER, Level.WARNING, ex);
                    }
                    finally {
                        DviUtils.silentClose(is);
                    }
                }
            });
            this.stdoutThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    InputStream is = CommandShell.this.p.getInputStream();
                    try {
                        CommandShell.this.handler.handleStdout(is);
                    }
                    catch (Exception ex) {
                        DviUtils.logStackTrace(LOGGER, Level.WARNING, ex);
                    }
                    finally {
                        DviUtils.silentClose(is);
                    }
                }
            });
            this.stderrThread.start();
            this.stdoutThread.start();
        }
    }

    public void stop() {
        if (this.p != null) {
            this.p.destroy();
        }
    }

    public static class DumpHandler
    implements Handler {
        private final PrintStream out;

        public DumpHandler(PrintStream out) {
            this.out = out;
        }

        public void handleStdout(InputStream in) throws IOException {
            this.dumpStream("stdout", in);
        }

        public void handleStderr(InputStream in) throws IOException {
            this.dumpStream("stderr", in);
        }

        private void dumpStream(String prefix, InputStream in) throws IOException {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            while (null != (line = r.readLine())) {
                this.out.println("[" + prefix + "] " + line);
            }
        }
    }

    public static interface Handler {
        public void handleStdout(InputStream var1) throws IOException;

        public void handleStderr(InputStream var1) throws IOException;
    }
}

