unit ecma_guiobject;

interface

uses
  Windows,Sysutils,Classes,ecma_type,ecma_checklistfrm,ecma_extobject,
  forms;

type
  TJCheckListBox = class(TJObject)
  private
    FItems: TJStringsObject;
    FChecks: array of Boolean;
    function GetCount: Integer;
    procedure StringsOnChange(Sender: TObject);
  protected
    function DoGetChecked(Param: TJValueList): TJValue;
    function DoSetChecked(Param: TJValueList): TJValue;
    function DoExecute(Param: TJValueList): TJValue;
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
    destructor Destroy; override;
  published
    property items: TJStringsObject read FItems;
    property count: Integer read GetCount;
  end;



implementation

{ TJCheckListBox }

constructor TJCheckListBox.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
begin
  inherited;
  RegistName('CheckListBox');
  //\bho^
  RegistMethod('getChecked',DoGetChecked);
  RegistMethod('setChecked',DoSetChecked);
  RegistMethod('execute',DoExecute);
  //
  FItems := TJStringsObject.Create(AFactory,nil);
  FItems.IncRef;
  //CxgZbg
  FItems.Strings.OnChange := StringsOnChange;
end;

destructor TJCheckListBox.Destroy;
begin
  FItems.Strings.OnChange := nil;
  FItems.DecRef;
  inherited;
end;

function TJCheckListBox.DoExecute(Param: TJValueList): TJValue;
//s
var
  frm: TfrmCheckList;
  i: Integer;
  lbl,capt: String;
  v: TJValue;
begin
  //labelcaption
  for i := 0 to Param.Count - 1 do
  begin
    v := Param[i];
    case i of
      0: capt := AsString(@v);
      1: lbl := AsString(@v);
    end;
  end;


  frm := TfrmCheckList.Create(Application.MainForm);
  try
    frm.Caption := capt;
    frm.lblText.Caption := lbl;

    //Zbg
    frm.lbCheck.Items.Assign(FItems.Strings);
    for i := 0 to Length(FChecks) - 1 do
      frm.lbCheck.Checked[i] := FChecks[i];

    if frm.ShowModal = IDOK then
    begin
      Result := BuildBool(True);
      //߂
      for i := 0 to frm.lbCheck.Items.Count - 1 do
        FChecks[i] := frm.lbCheck.Checked[i];
    end
    else
      Result := BuildBool(False);

  finally
    frm.Release;
  end;
end;

function TJCheckListBox.DoGetChecked(Param: TJValueList): TJValue;
var
  v: TJValue;
  index: Integer;
begin
  if IsParam1(Param) then
  begin
    v := Param[0];
    index := AsInteger(@v);
    try
      Result := BuildBool(FChecks[index]);
    except
      raise EJThrow.Create(E_INDEX,'CheckListBox.getChecked Index Error');
    end;
  end
  else
    Result := BuildBool(False);
end;

function TJCheckListBox.DoSetChecked(Param: TJValueList): TJValue;
var
  v: TJValue;
  index: Integer;
begin
  if IsParam2(Param) then
  begin
    v := Param[0];
    index := AsInteger(@v);
    v := Param[1];
    try
      FChecks[index] := AsBool(@v);
    except
      raise EJThrow.Create(E_INDEX,'CheckListBox.setChecked Index Error');
    end;
  end;
end;

function TJCheckListBox.GetCount: Integer;
begin
  Result := FItems.Strings.Count;
end;

procedure TJCheckListBox.StringsOnChange(Sender: TObject);
begin
  //booleanzZbg
  SetLength(FChecks,FItems.Strings.Count);
end;

end.
