
/*!
@file dkcSerialize.c
@auther d
@since 2004/3/xx
*/

#include "dkcSerialize.h"
#include "dkcMemoryStream.h"
#include "dkcString.h"
#include "dkcStdio.h"
#include "dkcSJISFileSystem.h"


typedef struct dkc_MemorySerializeSignature{
	DKC_MEMORYSTREAM *mpMem;
	DKC_STRING *mpString;
	BOOL mSerializeFlag;
}DKC_MSS__;



static const size_t gAllocMemoryStreamSize = 1024 * 32;//32KB


DKC_SERIALIZE * WINAPI dkcAllocSerialize(UINT mode,const char *filename)
{
	DKC_SERIALIZE *p = NULL;
	DKC_MSS__ *pmss = NULL;
	size_t len_of_fn = 0;

	p = dkcAllocate(sizeof(DKC_SERIALIZE));
	if(NULL==p) return NULL;
	
	
	if(mode & edkcSerializeBufferMode){
		len_of_fn = strlen(filename);
		pmss = dkcAllocate(sizeof(DKC_MSS__));
		if(NULL==pmss) goto Error;

		pmss->mpString = dkcAllocString(len_of_fn);
		if(NULL==pmss->mpString) goto Error;
		dkcmNOT_ASSERT(DKUTIL_FAILED(
			dkcStringCopy( pmss->mpString , filename,len_of_fn)
			));

		pmss->mpMem = dkcAllocMemoryStream(gAllocMemoryStreamSize);
		if(NULL==pmss->mpMem) goto Error;

		pmss->mSerializeFlag = TRUE;//serializêTRUE

		p->mSignature = pmss;
	}else if(mode & edkcSerializeFileMode){
		
		p->mSignature = (void *)fopen(filename,"wb");
		if(NULL==p->mSignature) goto Error;
	}else{
		goto Error;
	}

	p->mMode = mode;

	return p;

Error:
	if(pmss){
		dkcFreeString(&(pmss->mpString));
		dkcFreeMemoryStream(&(pmss->mpMem));
		dkcFree(&pmss);
	}
	dkcFree(&p);
	return NULL;
}

int WINAPI dkcFreeSerialize(DKC_SERIALIZE **ptr)
{
	DKC_MSS__ *pmss;
	DKC_SERIALIZE *ps;
	if(NULL==ptr || NULL==*ptr || NULL==(*ptr)->mSignature){
		return edk_FAILED;
	}
	ps = (*ptr);
	if(ps->mMode & edkcSerializeBufferMode){
		pmss = (DKC_MSS__ *)ps->mSignature;

		/* Ł@ۑ */
		dkcSaveBinary(pmss->mpMem->mBuffer,pmss->mpMem->mNowOffset,
			dkcStringPointer(pmss->mpString)
		);

		dkcFreeMemoryStream(&(pmss->mpMem));
		dkcFreeString(&(pmss->mpString));
		dkcFree(&pmss);
	}else if(ps->mMode & edkcSerializeFileMode){
		fclose((FILE *)ps->mSignature);
	}else{
		return edk_FAILED;
	}

	return dkcFree(ptr);
}


int WINAPI dkcSerializeWrite(DKC_SERIALIZE *ptr,const void *data,size_t size){
	DKC_MSS__ *pmss;
	dkcmNOT_ASSERT(NULL==ptr);

	if(ptr->mMode & edkcSerializeBufferMode){
		pmss = (DKC_MSS__ *)ptr->mSignature;
		if(DKUTIL_FAILED(
			dkcMemoryStreamDynamicWrite(pmss->mpMem,data,size)
			)){
			return edk_FAILED;
		}

	}else if(ptr->mMode & edkcSerializeFileMode){
		dkcmNOT_ASSERT(1 != fwrite(data,size,1,(FILE *)ptr->mSignature));
	}else{
		return edk_FAILED;
	}
	return edk_SUCCEEDED;
}

DKC_DESERIALIZE * WINAPI dkcAllocDeserialize(UINT mode,const char *filename)
{
	DKC_DESERIALIZE *p = NULL;
	DKC_MSS__ *pmss = NULL;
	size_t len_of_fn = 0;
	size_t filesize = dkcFileSize(filename);
	size_t readsize = 0;

	p = dkcAllocate(sizeof(DKC_DESERIALIZE));
	if(NULL==p) return NULL;
	
	if(0==filesize) goto Error;
	
	
	if(mode & edkcSerializeBufferMode)
	{
		len_of_fn = strlen(filename);
		pmss = dkcAllocate(sizeof(DKC_MSS__));
		if(NULL==pmss) goto Error;

		pmss->mpString = dkcAllocString(len_of_fn);
		if(NULL==pmss->mpString) goto Error;
		dkcmNOT_ASSERT(DKUTIL_FAILED(
			dkcStringCopy( pmss->mpString , filename,len_of_fn)
			));

		
		pmss->mpMem = dkcAllocMemoryStream(filesize);
		if(NULL==pmss->mpMem) goto Error;

		//[h
		if(DKUTIL_FAILED(
			dkcLoadBinary(pmss->mpMem->mBuffer,pmss->mpMem->mSize,filename,&readsize)
			)){
			goto Error;
		}
#	ifdef WIN32
		dkcmNOT_ASSERT(readsize != filesize);
#	endif
		pmss->mSerializeFlag = FALSE;//serializeȂFALSE 

		p->mSignature = pmss;

		

	}
	else if(mode & edkcSerializeFileMode)
	{
		
		p->mSignature = (void *)fopen(filename,"rb");
		if(NULL==p->mSignature) goto Error;
	}
	else
	{
		goto Error;
	}

	p->mMode = mode;

	return p;

Error:
	if(pmss){
		dkcFreeString(&(pmss->mpString));
		dkcFreeMemoryStream(&(pmss->mpMem));
		dkcFree(&pmss);
	}
	dkcFree(&p);
	return NULL;



}

int WINAPI dkcFreeDeserialize(DKC_DESERIALIZE **ptr)
{
	DKC_MSS__ *pmss;
	DKC_DESERIALIZE *ps;
	if(NULL==ptr || NULL==*ptr || NULL==(*ptr)->mSignature){
		return edk_FAILED;
	}
	ps = (*ptr);
	if(ps->mMode & edkcSerializeBufferMode){
		pmss = (DKC_MSS__ *)ps->mSignature;

		dkcFreeMemoryStream(&(pmss->mpMem));
		dkcFreeString(&(pmss->mpString));
		dkcFree(&pmss);
	}else if(ps->mMode & edkcSerializeFileMode){
		fclose((FILE *)ps->mSignature);
	}else{
		return edk_FAILED;
	}
	return dkcFree(ptr);
}

int WINAPI dkcDeserializeRead(DKC_DESERIALIZE *ptr,void *data,size_t size,size_t *readsize){

	DKC_MSS__ *pmss;

	dkcmNOT_ASSERT(NULL==ptr);

	if(ptr->mMode & edkcSerializeBufferMode){
		pmss = (DKC_MSS__ *)ptr->mSignature;

		dkcmNOT_ASSERT(DKUTIL_FAILED(
			dkcMemoryStreamRead(pmss->mpMem,data,size,readsize)
		));

	}else if(ptr->mMode & edkcSerializeFileMode){
		dkcmNOT_ASSERT(1 != fread(data,size,1,(FILE *)ptr->mSignature));
	}else{
		return edk_FAILED;
	}
	return edk_SUCCEEDED;
}

