#ifndef _dkutil_Shell__
#define _dkutil_Shell__


/*!
@note
QlTCg,
<ul>
<li>
炭
<a href="http://www.geocities.co.jp/SiliconValley-SanJose/9190/">
Cx+
</a>-> C++ Cu

</ul>

*/
#include "dkutilStdio.h"
#include "dkutilCommonControl.h"

#ifdef USE_DKINGYO_SHELL_AND_COMMON_CONTROL






#if DKUTIL_MSVC_MODE
#	pragma comment(lib,"shell32")
#	pragma comment(lib,"shlwapi") 
#endif

namespace dkutil{


/*!
fXNgbvtH_pX擾:fXNgbvtH_̃pX擾܂B
	@param	 *pPath[out]			: fXNgbvtH_󂯎镶|C^
	@return:  true / s false
*/
extern bool GetDesktopFolder( char *pPath );

/*!
V[gJbg:V[gJbg𐶐܂B
@param *pShortcutFile[in]		: 쐬[*.lnk]̃tpX
@param *pDescription[in]		: fBXNvV
@param *pTargetFile[in]		: Ñt@C̃tpX
@return		:  true / s false
*/
extern bool CreateLinkFile( char *pShortcutFile, char *pDescription, char *pTargetFile );
	

#if 0
/*!
@param CONTAINER[in] std::list<WIN32_FIND_DATA>݊ReiԂ
ʂtypedefĂ@FileFindergĂB<br>
FileFinderBase<>݂Ȃ股Ȃł^^;<br>
܂ACONTAINERύXłĂ̂ȂƎv̂ŁAiȂɃbg͂ȂƎv܂B)<br>
@note
2003/10/18<br>
̃NX͔p~܂Bfile_finder_basegB<br>

*/
template<class CONTAINER=std::list<WIN32_FIND_DATA> >
class FileFinderBase{
protected:
	FileFinderBase(const FileFinderBase&);
	FileFinderBase& operator =(const FileFinderBase&);


	CONTAINER mDataList;
	
	
	std::string mDir;
	TCHAR mTmp[MAX_PATH + MAX_PATH];
public:
	typedef CONTAINER::iterator iterator;
	
	FileFinderBase(){
		mDir.clear();
		mDataList.clear();
		
		{
			char tmp[MAX_PATH];
			::GetCurrentDirectory(sizeof(tmp),tmp);
			mDir = tmp;
		}
		NULL_CHAR_ARRAY(mTmp);
	}
	virtual ~FileFinderBase(){
		Release();
	}
	///ׂĂJAlɂBA܂FindĂяoƂoB
	void Release(){
		mDir.clear();
		mDataList.clear();
		NULL_CHAR_ARRAY(mTmp);
		{
			char tmp[MAX_PATH];
			::GetCurrentDirectory(sizeof(tmp),tmp);
			mDir = tmp;
		}
	}
	///@return ŎgĂstd::list<WIN32_FIND_DATA>݊Rei̎QƂԂB
	CONTAINER &GetContainer(){return mDataList;}
	///STLłȂ݂beginƓ
	iterator begin(){return mDataList.begin();}
	///STLłȂ݂endƓ
	iterator end(){return mDataList.end();}
	///fBNgݒ肷B
	void SetDirectory(char *dir){
		mDir = dir;
	}
	///ÃNXŎgĂfBNg𓾂B
	const char *GetDirectory()const{return mDir.c_str();}
	/*!
	@param filename[in] t@CiChJ[h :*.htmlƂ)
	@param set_directory[in] SetDirectoryɓ̂ƓB
	@return edk_SUCCEEDEDȂ琬I
	*/
	///w̃t@C鏈@Ȍʂ͏
	int Find(const char *filename,const char *set_directory=NULL){
		int result;
		bool ChangedDir = false;//DirectoryύXǂHtO
		result = edk_FAILED;

		//fBNgZbg
		{
			{
				int r;
				r = GetCurrentDirectory(sizeof(mTmp),mTmp);
				if(r == 0){
					goto end;
				}
			}
			//fBNg`FW
			if(set_directory){
				SetCurrentDirectory(set_directory);
				mDir = set_directory;
			}else if(!mDir.empty()){
				SetCurrentDirectory(mDir.c_str());
			}else{
				//SetCurrentDirectory(mTmp);
			}
			//tOĂƂ
			ChangedDir = true;
		}

		//OXg͍폜
		mDataList.clear();

		
		result = FindLogic(filename);
	end:
		//ύXfBNg͌ɖ߂
		if(ChangedDir){	SetCurrentDirectory(mTmp);}
		return result;
	}

private:
	bool isFolder(WIN32_FIND_DATA &FindFileData){
		return (
			FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY
			&& strcmp(FindFileData.cFileName,"..")!=0 
			&& strcmp(FindFileData.cFileName,".")!=0
			);
	}
	int FindLogic(const char *filename){
		int result = edk_FAILED;
		//T
		{
			char subpath[_MAX_PATH]="";
			char temp[_MAX_PATH]="";
			dkstrcpy2(temp,sizeof(temp),filename,strlen(filename));
			
			WIN32_FIND_DATA FindFileData;
			HANDLE hFind = FindFirstFile(filename, &FindFileData);
			
			//temp[strlen(temp)-1]='\0';//*Ă

			if(hFind != INVALID_HANDLE_VALUE){
				do{
					mDataList.push_back(FindFileData);
					if(isFolder(FindFileData))
					{
						dksprintf(subpath,sizeof(subpath),"%s%s\\",temp,FindFileData.cFileName);
						return FindLogic(subpath);
					}

					if(0==FindNextFile(hFind, &FindFileData)){
						break;
					}
				} while(true);
				FindClose(hFind);
				result = edk_SUCCEEDED;
			}
			else{
				VISUAL_LASTERROR();
			}
		}
		return result;
	}
public:
	/*
	@param ptr[out] obt@ւ̃|C^
	@para size[in] size[in] ptr̃TCY
	@param it[in] begin()iterationiteratorƂ
	@note
	iteratorgĂ֐
	TestFileFind()Ɨǂ邾낤B<br>
	*/
	bool GetFilePath(char *ptr,size_t size,iterator &it,LPTSTR directory=NULL) const
	{
		if(directory==NULL){
			directory = const_cast<char *>(GetDirectory());
		}
		//̊֐ĂԂȂˁH
		PathCombine((LPTSTR)mTmp, directory, (*it).cFileName);
		return DKUTIL_SUCCEEDED(dkstrcpy(ptr,size,mTmp,strlen(mTmp)));
	}

	/*!
	@param it[in] ɂiteratorԂŁI
	@return t@C̖Oւ̃|C^H
	*/
	///DESCRIPTION: Retrieves the filename of the file found.
	const char * GetFileName(iterator &it) const
	{
		return (*it).cFileName;
	}
	/*!
	@param ptr[out] obt@ւ̃|C^
	@param size[in] ptr̃TCY
	@param it[in] ̂Ă[
	*/
	///DESCRIPTION: Retrieves the title of the file found.
	bool GetFileTitle(char *ptr,size_t size,iterator &it) const
	{
		//std::string str = GetFileName();
		NULL_CHAR_ARRAY(mTmp);
		
		{
			char *p = (*it).cFileName;
			dkstrcpy((char *)mTmp,sizeof(mTmp),p,strlen(p));
		}

		if(!IsDots(it))
		{
			//PathRemoveExtension(str.GetBuffer(0));
			//str.ReleaseBuffer();
			PathRemoveExtension((LPTSTR)mTmp);
		}
		int r = dkstrcpy(ptr,size,mTmp,sizeof(mTmp));

		return DKUTIL_SUCCEEDED(r);
	}
	BOOL MatchesMask(iterator &it,DWORD dwMask) const
	{
		return ((*it).dwFileAttributes & dwMask);
	}
	///DotsIH
	BOOL IsDots(iterator &it) const
	{
		if(IsDirectory(it))
		{
			return PathIsDots((*it).cFileName);
		}
		return FALSE;
	}
	///@return RootDirectoryԂ,ĂGetDirectory()̃bp`
	///DESCRIPTION: Retrieves the root directory of the file found.
	const char * GetRoot() const
	{
		return GetDirectory();
	}

	/*!
	@param ptr[out] ̃obt@
	@param size[in] ptr̃TCY
	@param it[in] ̃Ce[^iiterator)
	*/
	///file://ptrɂԂ
	///DESCRIPTION: Retrieves the URL of the file found.
	bool GetFileURL(char *ptr,size_t size,iterator &it) const
	{
		NULL_CHAR_ARRAY(mTmp);
		GetFilePath((char *)mTmp,sizeof(mTmp),it);
		dksprintf((char *)ptr,size,_T("file://"));
		int r = dkstrcat2(ptr,size,mTmp);
		return DKUTIL_SUCCEEDED(r);
	}
	inline BOOL IsReadOnly(iterator it)   const { return MatchesMask(it,FILE_ATTRIBUTE_READONLY); }
	inline BOOL IsDirectory(iterator &it)  const { return MatchesMask(it,FILE_ATTRIBUTE_DIRECTORY); }
	inline BOOL IsCompressed(iterator &it) const { return MatchesMask(it,FILE_ATTRIBUTE_COMPRESSED); }
	inline BOOL IsSystem(iterator &it)     const { return MatchesMask(it,FILE_ATTRIBUTE_SYSTEM); }
	inline BOOL IsHidden(iterator &it)     const { return MatchesMask(it,FILE_ATTRIBUTE_HIDDEN); }
	inline BOOL IsTemporary(iterator &it)  const { return MatchesMask(it,FILE_ATTRIBUTE_TEMPORARY); }
	inline BOOL IsNormal(iterator &it)     const { return MatchesMask(it,FILE_ATTRIBUTE_NORMAL); }
	inline BOOL IsArchived(iterator &it)   const { return MatchesMask(it,FILE_ATTRIBUTE_ARCHIVE); }
	///it̃t@CTCYԂB
	inline ULONGLONG GetFileSize(iterator &it) const {
		return ((*it).nFileSizeLow + 
			((*it).nFileSizeHigh << 32));
	}
	BOOL PathIsDots(LPCTSTR lpszPath) const
	{
		if(*lpszPath == _T('.'))
		{
			switch(*(lpszPath + 1))
			{
				case _T('.'):
					if(*(lpszPath + 2))
					{
						break;
					}

				case _T('\0'):
					return TRUE;
			}
		}

		return FALSE;
	}
};

typedef FileFinderBase<> FileFinder ;

#endif //end of if 0





}//end of dkutil namespace



#endif//end of USE_DKINGYO_SHELL_AND_COMMON_CONTROL


#endif//end of include once