

#ifndef _dkutilLog__h__
#define _dkutilLog__h__

#include "dkutilCompileOption.h"

#ifdef USE_DKINGYO_INCLUDE_SETTING_LIKE_BOOST
#	if !defined(__GNUG__)
#		include <dkutil/dktl/array_onebyone.h>
#	endif
#	include <dkutil/dkutilGetParam.h>
#else
#	if DKUTIL_COMPILE_OPTION_MSVC
#		include "dktl/array_onebyone.h"
#		include "dkutilGetParam.h"
#	else
#		include "array_onebyone.h"
#		include "dkutilGetParam.h"
#	endif
#endif


namespace dkutil{


//extern bool dInitLog( const char *filename );

//extern bool dAddLog( const char *filename,const char *str , ... );


///G[O(t@C) @param filename[in] t@C̖O
inline bool dInitLog( const char *filename )
{
	FILE *fp;
	// G[Ot@CJ()
	if(NULL==(fp = fopen( filename , "wt" ))){
		return false;
	}
	fclose( fp ) ;
	
	return true;
}
///Of @param filename[in] t@Cl[ @param str[in] f
inline bool dAddLog( const char *filename,const char *str , ... ){
	FILE *fp=NULL;
	char s[2048]="";
	SET_VA_LIST_INSERT_YEN_N(s,2048,str);
	
	//t@CI[v
	if(NULL == (fp = fopen( filename , "at" )))
		return false;
	// G[Ot@Cɏo
	fputs( s , fp ) ;
	fclose( fp ) ;
	return true;
}



class HTMLLog{
protected:
	std::string m_name;
	int m_exSize;

	/**	OJn
		Oo͂̊Jn܂B
	*/
	bool LogoutStart(char *titlename)
	{

		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return false;

		fprintf( fp,
			"<HTML>\n"
			"<HEAD>\n"
			"<META http-equiv=\"Content-Type\" content=\"text/html; charset=Shift_JIS\">\n"
			"<TITLE>%s</TITLE>\n"
			"<STYLE type=\"text/css\">\n"
			"<!--\n"
			"BODY{\n"
			"  font-size : 12px;\n"
			"  font-family : \"lr SVbN\";\n"
			"}\n"
			"-->\n"
			"</STYLE>\n"
			"</HEAD>\n"
			"<BODY bgcolor=\"#ffffff\" text=\"#000000\" link=\"#444444\" vlink=\"#444444\" alink=\"#444444\">\n",
			titlename );

		fclose( fp );
		return true;
	}

	/**	OI
		Oo͂̏I܂B
	*/

	bool LogoutEnd()
	{

		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return false;

		fprintf( fp,
			"</BODY>\n"
			"</HTML>\n" );

		fclose( fp );
		return true;
	}

public:
	///@param logfiletitle[in] HTMLOt@C̃^Cgw肵ĂB
	///@param fullpathname[in] t@CpX̓tpXwŌ肢܂B
	HTMLLog(char *logfiletitle="DebugLog",char *fullpathname = "debuglog.html")
	{
		m_name = fullpathname;
		m_exSize = MAX_PATH;
		LogoutStart(logfiletitle);
	}
	virtual ~HTMLLog()
	{
		LogoutEnd();
	}
	//eAg\̕ǂ邩Bi܂ĂȂB
	void SetExtensionStringSize(int size){
		m_exSize = size;
	}

	///@param name[in] t@C͐UpXwŌ肢܂B
	void SetLogFileName(char *name){		m_name = name;	}
	char *GetLogFileName(){return const_cast<char *>(m_name.c_str());}

	/**	Oo̓JeS[
		Oo͂JeS[p̐Fŏ܂B

		@param pStr		[in] `敶iprintf()Ɠl̏j
	*/
	void LogoutMainCategory( char *pStr )
	{


		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return;

		fprintf( fp,
			"<TABLE width=\"100%%\" bgcolor=\"#000000\">\n"
			"  <TBODY>\n"
			"    <TR>\n"
			"      <TD align=\"center\">\n"
			"        <B>\n"
			"          <FONT color=\"WHITE\">" );

		vfprintf( fp, pStr, (char*)(&pStr + 1) );

		fprintf( fp,
			"</FONT>\n"
			"        </B>\n"
			"      </TD>\n"
			"    </TR>\n"
			"  </TBODY>\n"
			"</TABLE>\n" );

		fclose( fp );
	}
	/**	Oo̓L[[h
		Oo͂L[[hp̐Fŏ܂B

		@param pStr		[in] `敶iprintf()Ɠl̏j
	*/
	void LogoutKeyword( char *pStr,... )
	{

		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return;

		fprintf( fp, "<B><FONT color=\"BLUE\">" );
		vfprintf( fp, pStr, (char*)(&pStr + 1) );
		fprintf( fp, "</FONT></B>" );

		fclose( fp );
	}
	/**	Oo̓G[
		Oo͂G[p̐Fŏ܂B

		@param pStr		[in] `敶iprintf()Ɠl̏j
	*/
	void LogoutError( char *pStr,... )
	{
		
		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return;
		//bool f;
		//char *str;
		//BEGIN_GET_MANY_ARG(f,str,m_exSize,pStr);
		//if(f==false) return;
		fprintf( fp, "<B><FONT color=\"RED\">" );
		//fprintf( fp, str);
		vfprintf( fp, pStr, (char*)(&pStr + 1) );
		fprintf( fp, "</FONT></B>" );
		//END_GET_MANY_ARG(str);
		fclose( fp );
	}

	/**	Oo͂nj
		Oo͂njp̐Fŏ܂B

		@param pStr		[in] `敶iprintf()Ɠl̏j
	*/
	void LogoutOK( char *pStr,... )
	{

		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return;

		fprintf( fp, "<B><FONT color=\"GREEN\">" );
		vfprintf( fp, pStr, (char*)(&pStr + 1) );
		fprintf( fp, "</FONT></B>" );

		fclose( fp );
	}

	/**	Oo͑
		Oo͂𑾎ōs܂B
		@param pStr		[in] `敶iprintf()Ɠl̏j
	*/
	void LogoutStrong( char *pStr,... )
	{

		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return;

		fprintf( fp, "<B>" );
		vfprintf( fp, pStr, (char*)(&pStr + 1) );
		fprintf( fp, "</B>" );

		fclose( fp );
	}

	/*!	Oo<BR>
		Oo͂܂B

		@param pStr		[in] `敶iprintf()Ɠl̏j
	*/
	void Logout( char *pStr,... )
	{

		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return;

		vfprintf( fp, pStr, (char*)(&pStr + 1) );

		fclose( fp );
	}
	/*!	Os<BR>
		Oo͂̉s܂B
	*/
	void LogoutNextLine( void )
	{

		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return;

		fprintf( fp, "<BR>\n" );

		fclose( fp );
	}

};
#if !defined(__GNUG__)
class HTMLLogFactory{
public:
	typedef array_onebyone_ex<HTMLLog> CONTAINER_TYPE;
	typedef CONTAINER_TYPE::handle handle;
	typedef CONTAINER_TYPE::size_type size_type;
	typedef CONTAINER_TYPE::reference reference_type;
protected:
	CONTAINER_TYPE m_c;
public:
	HTMLLogFactory(){}
	virtual ~HTMLLogFactory(){}
	handle Construct(char *title,char *filefullpath){ 
		return m_c.push(HTMLLog(title,filefullpath));
	}
	void Destroy(handle h){
		m_c.pop(h);
	}
	HTMLLog &Reference(handle h){
		return m_c.at(h);
	}
	size_type size(){	return m_c.size();}
};
#endif

//extern void HTMLLogTest();

/*	
inline bool GetVersionInfoForProgrammer(std::string &s){
	char buff[1024]="";
	GetVersionInfo v;

	const int num = 
	const char *dllname[num]={
		"KERNEL32.DLL",
		"AVIFIL32.DLL",
		"MSVFW32.DLL",
		"COMCTL32.DLL",
		"MSVCRT.dll",
		"OLEPRO32.dll",
		"OLEAUT32.dll",
		"MSHTML.dll",
	}
	s += 

}
*/

}//end of dkutil namespace

#endif //end of include once

	
