#ifndef _dkutilGetParam__
#define _dkutilGetParam__

#include "dKingyoMacro.h"
#include "dkutilStdio.h"
#include "dkutilCompileOption.h"

#if DKUTIL_COMPILE_OPTION_MSVC
#	pragma comment(lib,"version.lib")
#endif

namespace dkutil{

extern int dkstrcpy_amap2(char *,size_t,const char *);

struct GetVersionInfo{
protected:
	/*!
	<b>:</b>
	̊֐́Ao[W\[X̃Rs[ւ̃|C^ԂB<br>
	o[W\[X̃Rs[́AgpɉȂĂ͂ȂȂB<br>
	@return void * cc ֐ o[W\[X̃Rs[ւ̃|C^ 
							@@ ֐s NULL ԂB
	@param *FileName[in]   t@C
	@param **dwTrans[out]   o[W\[X̌
	*/
	void *GetVersionInfo_( LPTSTR FileName, DWORD **dwTrans )
	{
		void  *pVersionInfo=NULL; // o[W\[Xw|C^
		UINT   uDumy = 0;        //
		DWORD  dwDumy = 0;       //
		DWORD  dwSize = 0;       // o[W\[X̃TCY

		// o[W\[X̃TCY擾
		dwSize = ::GetFileVersionInfoSize( FileName, &dwDumy );
		if ( dwSize <= 0 ) return NULL; // s

		pVersionInfo = DKUTIL_SAFE_MALLOC( dwSize );
		if ( !pVersionInfo ) return NULL; // s

		// o[W\[X擾
		if ( ::GetFileVersionInfo( FileName, 0, dwSize, pVersionInfo ) )
		{
			// o[W\[X̌擾
			if ( VerQueryValue( pVersionInfo, //"\\VarFileInfo\\Translation",
				"\\",(void **)dwTrans, &uDumy ) )
			{
				return pVersionInfo;
			}
		}
		DKUTIL_SAFE_FREE( pVersionInfo );
		return NULL; // s
	}//GetVersionInfo

	/*!
	<b>:</b>
	o[W\[XAo[W̃Rs[擾B<br>
	@return     BOOL cc ֐ TRUE  A ֐s FALSE ԂB
	@param char  *Buffer[out] 擾o[W󂯎obt@
	@param void  *pVersionInfo[out] ֐GetVersionInfo() ̖߂l
	@param DWORD  dwTrans[in] o[W\[X̌
	@param const char  *KeyWord[in] 擾o[W̖O (ڂGetInfo()wantɂ
	*/
	BOOL GetVersionValue( char *Buffer,size_t BufferSize, void *pVersionInfo, DWORD dwTrans, const char *KeyWord )
	{
		char *pValue=NULL; // o[W\[X̃o[Ww|C^
		char  Path[MAX_PATH+1]="";
		UINT  uDumy = 0;
		WORD  wCodePageID[] = { 0, 932, 949, 950, 1200, 1250, 1251, 1252, 1253, 1254, 1255, 1256 };
		WORD  wLanguageID[] = { 0x0401, 0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 0x0407, 0x0408, 0x0409, 0x040A, 0x040B, 0x040C, 0x040D, 0x040E, 0x040F, 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0416, 0x0417, 0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F, 0x0420, 0x0421, 0x0804, 0x0807, 0x0809, 0x080A, 0x080C, 0x0810, 0x0813, 0x0814, 0x0816, 0x081A, 0x0C0C, 0x100C };

		sprintf( Path, "\\StringFileInfo\\%04x%04x\\%s", LOWORD(dwTrans), HIWORD(dwTrans), KeyWord );
		if ( VerQueryValue( pVersionInfo, Path, (void **)&pValue, &uDumy ) )
		{
			//strcpy( Buffer, pValue );
			dkstrcpy_amap2(Buffer,BufferSize,pValue);
			return TRUE; // 
		}

		// o[W\[XɌ񂪋L^ĂȂꍇ
		for( int i = 0; i < ( numof(wCodePageID) ); i++ )
		{
			for( int j = 0; j < numof(wLanguageID); j++ )
			{
				sprintf( Path, "\\StringFileInfo\\%04x%04x\\%s", wLanguageID[j], wCodePageID[i], KeyWord );
				if ( VerQueryValue( pVersionInfo, Path, (void **)&pValue, &uDumy ) )
				{
					dkstrcpy_amap2(Buffer,BufferSize,pValue);
					return TRUE; // 
				}
			}
		}

		Buffer[0] = '\0';
		return FALSE; // s
	}//GetVersionValue

public:
	GetVersionInfo(){}
	/*!
	@param filename[in] o[W𒲂ׂt@Cւ̃pX
	@param buff[in] ׂ̕i[obt@
	@param bufsize[in] obt@̃TCY
	@param want[in] ׂ̎w@LQ<br>
	<PRE>
	      "Comments"         // Rg
	      "CompanyName"      // Ж
	      "FileDescription"  // 
	      "FileVersion"      // t@Co[W
		    "InternalName"     // 
	      "LegalCopyright"   // 쌠
	      "LegalTrademarks"  // W
	      "OriginalFilename" // t@C
	      "PrivateBuild"     // vCx[grh
	      "ProductName"      // i
	      "ProductVersion"   // io[W
	      "SpecialBuild"     // XyVrh
	</PRE>
	@return trueŏ肭擾łB
	*/
	bool GetInfo(const char *filename,char *buff,size_t bufsize,const char *want)
	{
		// argv[0]igj̃o[W
		void *pVersionInfo=NULL;
		DWORD *dwTrans=NULL;
		char filenamebuff[1024]="";
		dkstrcpy_amap2(filenamebuff,sizeof(filenamebuff),filename);
		
		pVersionInfo = GetVersionInfo_(filenamebuff, &dwTrans );
		if (! pVersionInfo ) return false;
		
		GetVersionValue( buff,bufsize, pVersionInfo, *dwTrans, want ); 
		DKUTIL_SAFE_FREE( pVersionInfo );
		return true;
		
	}
	bool GetFileInfo(LPCTSTR filename,VS_FIXEDFILEINFO *vffi){
		ULONG tem;
		char filenamebuff[1024]="";
		dkstrcpy_amap2(filenamebuff,sizeof(filenamebuff),filename);
		UINT size = GetFileVersionInfoSize(filenamebuff,&tem);
		//size += 5;
		void *vbuf = DKUTIL_SAFE_MALLOC(size);
		bool r = false;
		if (GetFileVersionInfo(filenamebuff, 0, size, vbuf))
		{
				void *buf = NULL;
				VerQueryValue(vbuf,TEXT("\\"),&buf,&size);         // o[W擾
				CopyMemory( vffi, buf, sizeof(VS_FIXEDFILEINFO)); //Rs[
				r = true;
		}

		//  vffi \̂ɂ낢Ă̂łKvɉăRs[
		//  RgȂǎ擾Ƃ̒Ŏ擾

		DKUTIL_SAFE_FREE(vbuf); // 
		return r;
	}

};//end of struct class


///dRpC̃CuɎgSTLPort̃o[WԂ܂B
///@return _STLPORT_VERSION@/@STLPortgĂȂ炵edk_FAILED
extern int GetCompiledDKUTIL_STLPortVersion();

///dRpC̃CuɎgBoost̃o[WԂ܂B
///@return BOOST_VERSION
extern int GetCompiledDKUTIL_BoostVersion();

///dRpC̃CuɎgzlib̃o[WԂ܂B
///@return ZLIB_VERSION : "ERROR:֐"== zlib͎gĂȂ
extern const char *GetCompiledDKUTIL_zlibVersionString();

///dRpC̃CuɎglibpng̃o[WԂ܂B
///@return PNG_LIBPNG_VER_STRING : "ERROR:֐"== libpng͎gĂȂ
extern const char *GetCompiledDKUTIL_libpngVersionString();
///GetCompiledDKUTIL_libpngVersionString()̐łłB
///@return PNG_LIBPNG_VER : edk_FAILED==libpng͎gĂȂB
extern int GetCompiledDKUTIL_libpngVersion();
/*!
@param flag[in] trueƁAdKingyoUtilClass̒쌠ƎӎRs[{ԂĂB
@param copy[out] Rs[obt@
@param size[in] Rs[obt@̃TCY
*/
///@return ̃CuCopyright̕
extern const char *GetdKingyoUtilClassOriginalCopyright(bool flag=true,char *copy=NULL,size_t size=NULL);



}//end of dkutil namespace
	

#endif
