
/*!
@since 2003/10/16
*/


#ifndef _dkutilFileSystem__h_
#define _dkutilFileSystem__h_

#if defined(WIN32) 
#include "dkutilFSWin32Common.h"
#endif

#ifdef USE_DKINGYO_INCLUDE_SETTING_LIKE_BOOST
#include <dkutil/include/dkutilBoostPolicy.h>
#include <dkutil/dkutilFunction01.h>
#else
#	ifdef _MSC_VER
#		include "include/dkutilBoostPolicy.h"
#		include "dkutilFunction01.h"
#	else
#		include "dkutilBoostPolicy.h"
#		include "dkutilFunction01.h"
#	endif
#endif




namespace dkutil{
namespace policy{
	/// ǂݏo[hŊJBt@CȂAȂꍇ́AG[
	extern const char *f_readonly;
	/// ݃[hŋ̃t@CJBw肳ꂽt@CɂƁÃt@C͏łB 
	extern const char *f_writeonly;
	///  EOF }[J[폜ɁAt@CɒǋLł܂Bt@CȂꍇ͍쐬܂B
	extern const char *f_postscriptonly;
	/// ǂ݂݂Ə݂̗̃[hŊJB (Ώۂ͊t@C)
	extern const char *f_read;  
	///ǂ݂݂Ə݂̗̃[hŋ̃t@CJBw肳ꂽt@CɂƁÃt@C͏łB
	extern const char *f_write;
  ///ǋL[hœǂ݂݂Ə݂̗̃[hŊJBt@CȂꍇ͍쐬܂
  extern const char *f_postscript;
	///oCi[hŊJB
	extern const char *f_binary;
	///eLXg[hŊJB
	extern const char *f_text;

	
}//end of policy namespace

///@return std::stringԂGetCurrentDirecory()
inline std::string SafeGetCurrentDirectory(){
	char buff[MAX_PATH * 2]="";
	DWORD r = ::GetCurrentDirectory(sizeof(buff),buff);
	size_t len = strlen(buff);
	if(r != len) throw std::logic_error("SafeGetCurrentDirectory Buffer Was Lost");
	return std::string(buff);
}
/*!
@param s[in] fBNg̕񂪓std::string
@param bForce[in] trueƁAfBNg݂ȂĂIɃfBNg
@return true͐
*/
///ftHgł̓fBNgƂAIɃfBNg悤ɏoĂB
inline bool SafeSetCurrentDirectory(const std::string &s,bool bForce=true){
	if(bForce==true){//IDirectory
		if(false==FileAndFolderExist(s.c_str())){
			DKUTIL_RETURN_FALSE(CreateDirectory(s.c_str()));
		}
	}
	if(FALSE==SetCurrentDirectory(s.c_str()))
	{
		return false;
	}
	return true;
}

///@return ChJ[hTRUEiȊgqtĂTRUE)
inline bool isWildCard(const char *wcard){
	char *ptr = dkutil::GetFileExtension(wcard);
	if(ptr == wcard || ptr == NULL) return false;
	return true;
}
/*!
@param s[in] t@C̊gqstd::stringf[^B
@param exe[in] t@C̊gq *. ͕sv F"txt"
@return TRUEexeƓe
*/
///t@C̊gqexeƓǂm߂
inline bool FileExtensionCompare(const std::string &s,const char *exe){
	std::string tmp = dkutil::GetFileExtension(s.c_str());
	if(tmp != exe){
		return false;
	}
	return true;
}

///t@C̃tpXtH_[pX𓾂B
inline bool FileFullPathToFileFolderPath(const std::string &src,std::string &dest){
	if(src.empty()) return false;
	if(src.length() <= 3) return false;
	std::string::const_reverse_iterator rit=src.rbegin();
	for(;rit != src.rend();rit++)
	{
		if((*rit) == '\\'){
			std::string::const_reverse_iterator tit = rit;
			dest.clear();
			for(;tit != src.rend();tit++){
				dest.insert(dest.begin(),(*tit));
			}
			return true;
		}
	}
	return false;
}
/*!
@param src[in] t@C̃tpXstd::string
@param dest[out] t@C̃pX݂̂ɂȂ̂i[string
@return trueȂ琬
@note
F<br>
C:\boot.ini  boot.ini<br>
C:\Windows\winwin.exe  winwin.exe<br>

*/
///t@Cւ̃tpX𕁒ʂ̃pXɂB
inline bool FileFullPathToFilePath(const std::string &src,std::string &dest){
	if(src.empty()) return false;
	std::string::const_iterator it=src.begin();
	std::string::const_iterator re=src.begin();
	for(;it != src.end();it++)
	{
		if('\\'==(*it)){
			re = it;
		}
			
	}
	if(re==src.begin()) return false;
	//dest.clear();
	for(;re != src.end();re++){
		dest +=(*re);
	}
	//dest.insert(re,src.end());
	return true;
}


/*!
@param dir[in][out] fBNg̖O@AɃt@C̖OǋLB
@param filename[in] t@C̖O
@return trueƐ
@throw std::stringG񉽂𓊂B
*/
///fBNgƃt@C̖OqB
inline bool DirectoryPlusFileName(std::string &dir,const char *filename){
	size_t len = strlen(filename);
	if(len >= 2){
		if((dkutil::isAlpha(filename[0]) && filename[1] == ':')){
			return false;
		}
	}
	if(!dir.empty()){
		if(*(dir.end() - 1) != '\\'){
			dir.insert(dir.end(),'\\');
		}
	}
	if('\\' == *filename){
		dir += (filename + 1);
	}else{
		dir += filename;
	}

	
	return true;
}
///@return s΃pXTRUE
inline bool isRelativityPath(const char *s,size_t size){
	if(size <= 3){
		if(s[1] == '.'){
			goto LabelSucceeded;
		}
		std::string str = s;
		str += " path is invalid!!" ;
		str += __FILE__;
		str += to_string(__LINE__);
		throw std::invalid_argument(str);
	}
LabelSucceeded:
	if(dkutil::isAlpha(s[0]) && s[1]==':') return false;
	return true;
}
///@return s΃pXTRUE
inline bool isAbsolutelyPath(const char *s,size_t size){
	return !isRelativityPath(s,size);
}
///Z:\dkaftk_test\.\test.cpp ƂȂĂ̂@Z:\dkaftk_test\test.cpp̂悤ɒ܂B
///@return ȂTRUE@̂܂܂ȂFALSE
inline bool LocalPathErrorCorrection(std::string &str){
	std::string::iterator it=str.begin();
	size_t count=0;
	bool r=false;
	for(;it!=str.end();it++,count++){
		if(*it=='\\' && count + 2 < str.size()){
			if(*(it + 1) == '.' && *(it + 2) == '\\')
			{
				it = str.erase(it,it + 2);
				r = true;
			}
		}
	}
	return r;
}




///fopen,fclose,fread,fwrite,fseek,ferror,feof ̊ȒPȃbp[ił́I
class file_operator{

	std::string mfilename;
	std::string mmode;
	FILE *mfp;
	void check_fp()const{
		DK_TRUE_ASSERT_OR_THROW(
			!mfp,
			std::runtime_error("file_operator:openĂȂB")
		);
	}
public:
	file_operator(const char *filename=NULL,
		const char *mode=policy::f_readonly,
		const char *type=policy::f_binary)
	{
		mfp=NULL;
		if(filename){mfilename=filename;}
		mmode = mode;
		mmode += type;
	}
	file_operator(const file_operator &c){
		mfp=NULL;
		mfilename = c.filename();//.c_str();
		mmode = c.mode();//.c_str();
		
		
	}

	virtual ~file_operator(){close();}
	bool reset(const char *filename,const char *mode,const char *type){
		close();
		DK_TRUE_ASSERT_OR_THROW((filename==NULL || mode==NULL || type==NULL),
			std::invalid_argument("file_operator::resetinvalid argument"));

		mfilename=filename;
		mmode = mode;
		mmode += type;
		return true;
	}
	const char *filename()const{return mfilename.c_str();}
	const char *mode()const{return mmode.c_str();}
	bool open(){
		close();
		mfp=::fopen(mfilename.c_str(),mmode.c_str());
		if(mfp==NULL) return false;
		return true;
	}
	const FILE *handle()const{return mfp;}
	/*size_t read(const void *buf,size_t size){
		check_fp();
		return fread(const_cast<void *>(buf),1,size,mfp);
	}
	size_t write(const void *buf,size_t size){
		check_fp();
		return fwrite(const_cast<void *>(buf),1,size,mfp);
	}*/
	size_t read(void *buf,size_t size){
		check_fp();
		return fread((buf),1,size,mfp);
	}
	size_t write(void *buf,size_t size){
		check_fp();
		return fwrite((buf),1,size,mfp);
	}
	bool eof()const{
		check_fp();
		return ( 0 != feof(mfp) );
	}
	bool error()const{
		check_fp();
		return ( 0 != ferror(mfp) );
	}
	bool seek(long offset, int origin ){
		check_fp();
		return (0 == fseek(mfp,offset,origin) );
	}
	
	void close(){
		if(mfp){::fclose(mfp);mfp=NULL;}
	}

};




template<
	class PATH=boost::filesystem::path,
	class DIR_IT=boost::filesystem::directory_iterator
>
class file_finder_base{
public:
	struct dir_data{
		dir_data(const char *getdir){
			dir = getdir;
		}
		dir_data(std::string getsdir){
			dir = getsdir;
		}
		std::string dir;
	};
	typedef std::deque<dir_data> QUEUE_TYPE;
	typedef std::list<std::string> CONTAINER_TYPE;
	typedef CONTAINER_TYPE::iterator iterator;
	typedef CONTAINER_TYPE::const_iterator const_iterator;
private:
	PATH mpath;
	DIR_IT mdirit;
	QUEUE_TYPE mq;
	CONTAINER_TYPE mc;


	void AllClear(){
		mq.clear();
		mc.clear();
	}
	///qɃfBNgB
	void PushDirectory(QUEUE_TYPE &q,const char *dir)
	{
		namespace fs = boost::filesystem;
		DIR_IT end;
		PATH path(dir,boost::filesystem::native);
		for( DIR_IT it(path); it != end; ++it)
		{
			if( fs::is_directory(*it)){
				q.push_back(dir_data(it->native_directory_string()));
				PushDirectory(q,it->native_directory_string().c_str());
			}/*else{
				//dODS("native file string=%s",it->native_file_string());
			}*/
		}
	}
	void (*LOGIC_TYPE)(const char *,const char *,CONTAINER_TYPE);
	///boost::filesystemgČ
	void SearchLogic_Boost(const char *name,const char *dir,CONTAINER_TYPE &c)
	{
		namespace fs = boost::filesystem;
		DIR_IT end;
		PATH path(dir,boost::filesystem::native);
		for( DIR_IT it(path); it != end; ++it)
		{
			if( fs::is_directory(*it)){
			}else{
				//dODS(it->native_file_string().c_str());
				//߂I
				if(name==it->native_file_string())
				{
					c.push_back(it->native_file_string());
				}
			}
		}
	}
	///̓tH_[Iƒf肷
	bool isFolder(WIN32_FIND_DATA &FindFileData){
		return (
			FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY
			&& strcmp(FindFileData.cFileName,"..")!=0 
			&& strcmp(FindFileData.cFileName,".")!=0
			);
	}
	///TutH_܂߂Ɍ
	int SearchLogic_WildCard(const char *wc,const char *dir,CONTAINER_TYPE &c)
	{
		int result=edk_FileNotFound;
		char path[MAX_PATH];
		char fullpath[MAX_PATH];
		{
			//fBNg̃pX
			size_t len=strlen(dir);
			dkstrcpy_amap(path,sizeof(path),dir,len);
			if(path[len]!='\\'){
				char s[2]={'\\','\0'};
				dkstrcat_amap2(path,sizeof(path),s);
			}
			
			//tpXLĂ
			dkstrcpy_amap(fullpath,sizeof(fullpath),path,strlen(path));
			//pX쐬
			dkstrcat_amap2(path,sizeof(path),wc);
		}

		WIN32_FIND_DATA FindFileData;
		HANDLE hFind = FindFirstFile(path, &FindFileData);
		

		if(hFind != INVALID_HANDLE_VALUE){
			char buff[MAX_PATH];
			do{
				NULL_CHAR_ARRAY(buff);
				dkstrcpy_amap(buff,sizeof(buff),fullpath,strlen(fullpath));
				dkstrcat_amap2(buff,sizeof(buff),FindFileData.cFileName);
				c.push_back(buff);

				if(0==FindNextFile(hFind, &FindFileData)){
					break;
				}
			} while(true);
			FindClose(hFind);
			result = edk_SUCCEEDED;
		}
		else{
			//VISUAL_LASTERROR();
		}
		return result;
	}
	


public:
	file_finder_base(){}
	virtual ~file_finder_base(){}
	iterator begin(){return mc.begin();}
	iterator end(){return mc.end();}
	/*!
	@param wc[in] wildcardȕ ڂFindWildCardLogic()
	@param dir[in] tH_ւ̃pX
	@param receptacle[out] i[Rei
	*/
	void FindFromFolderLogic(const char *wc,const char *dir,CONTAINER_TYPE &receptacle){
		SearchLogic_WildCard(wc,dir,receptacle);
	}
	///̃tH_TÃReiɌʂB ڂFindFromFolderLogic()
	void find_from_folder(const char *wc,const char *dir){
		FindFromFolderLogic(wc,dir,mc);
	}
	/*!
	@param wc[in] WildCardȕ(: "*.*" Ƃ "*.txt"Ƃ "?a.b"Ƃ
	@param dir[in] Directoryȕ@KŌ"\" (Cł'\\'ŏI悤ɂĂB
	@param receptacle[in][out] ʂۑꕨ̎Q
	*/
	void FindWildCardLogic(const char *wc,const char *dir,CONTAINER_TYPE &receptacle){
		AllClear();
		PushDirectory(mq,dir);
		SearchLogic_WildCard(wc,dir,receptacle);
		QUEUE_TYPE::iterator it=mq.begin();
		for(;it != mq.end();it++)
		{
			SearchLogic_WildCard(wc,(*it).dir.c_str(),receptacle);
		}
	}
	/*!
	̃NX̓̓ꕨgăChJ[hgB
	̌ʂQƂɂ͂̃NXbegin()end()g
	@return falseȂȂ
	*/
	bool find_wc(const char *wc,const char *dir){
		FindWildCardLogic(wc,dir,mc);
		if(mc.empty())return false;
		return true;
	}
	/*!
	@param filename[in] Tt@C̕(: "file.txt" Ƃ "file.bmp"Ƃ "aho.cpp"Ƃ
	@param dir[in] Directoryȕ@KŌ"\" (Cł'\\'ŏI悤ɂĂB
	@param receptacle[in][out] ʂۑꕨ̎Q
	*/
	void FindLogic(const char *filename,const char *dir,CONTAINER_TYPE &receptacle){
		AllClear();
		//fBNgL[ɋl߂B
		PushDirectory(mq,dir);
		//܂͐fBNg
		SearchLogic_Boost(filename,dir,receptacle);
		//͌fBNg
		QUEUE_TYPE::iterator it=mq.begin();
		for(;it != mq.end();it++)
		{
			SearchLogic_Boost(filename,(*it).dir.c_str(),receptacle);
		}
	}
	/*!
	̃NX̓̓ꕨgăt@Cw肵ČB
	̌ʂQƂɂ͂̃NXbegin()end()g
	@return falseȂȂ
	*/
	bool find(const char *filename,const char *dir){
		FindLogic(filename,dir,mc);
		if(mc.empty()) return false;
		return true;
	}

	


};

///file_finder_basẽev[g`B
typedef file_finder_base<> file_finder;



/*!
JgfBNgꎞ`FWAXR[vAEgƌɖ߂Ă܂B
*/
///fBNgꎞ`FWƂɎg܂B
class scoped_current_directory{
	std::string mPreviousDir;
public:
	scoped_current_directory(const char *dir=NULL){
		try{
			if(dir){
				reset(dir);
			}
		}catch(...){
			undo();//߂Ă
			throw;//󂯎̂܂Ă
		}
	}
	virtual ~scoped_current_directory(){undo();}
	///fBNgύXB
	bool reset(const char *dir,bool bForce=false)
	{
		synchronized lock;
		if(empty()==false){//łɎgpς݂ꎞ߂B
			undo();
		}

		if(bForce==true){//IDirectory
			if(false==FileAndFolderExist(dir)){
				DKUTIL_RETURN_FALSE(CreateDirectory(dir));
			}
		}else{
			DKUTIL_RETURN_FALSE(FileAndFolderExist(dir));
		}
		mPreviousDir = SafeGetCurrentDirectory();
		if(FALSE==SetCurrentDirectory(dir))
		{//܂AG[0ɋ߂悤ȋC邪
			mPreviousDir.clear();
			return false;
		}
		return true;
	}
	///fBNgɖ߂
	bool undo(){
		synchronized lock;
		if(mPreviousDir.empty()) return false;
		if(FALSE==SetCurrentDirectory(mPreviousDir.c_str()))
		{
			return false;
		}
		mPreviousDir.clear();
		return true;
	}
	bool empty()const{return mPreviousDir.empty();}
	const std::string &previous_directory()const{return mPreviousDir;}

};

}//end of dkutil namespace








#endif //end of include once 
