#ifndef _dkutil_CommonControl__
#define _dkutil_CommonControl__


#ifdef USE_DKINGYO_SHELL_AND_COMMON_CONTROL

#include <shlobj.h>
#include <mbstring.h>
#include <Shlwapi.h>
#include <objbase.h>
#include <commctrl.h>
//#include <winnls32.h> ƁApWindowsŋNł˂I
#include <imm.h>
#include <basetsd.h>
//#include <mmreg.h>
#include "dKingyoMacro.h"
#include "dkutilDefined.h"
#include "dkutilStdio.h"
#include "dkutilDLLManager.h"

#if _MSC_VER >= 1200
#pragma comment(lib,"comctl32")
#pragma comment(lib,"imm32")
#endif
;
namespace dkutil{

/*!
IME\ݒIME\̐ݒ܂B
@param wnd[in] Window̃nhB(NULLƁAIME邩Ȃ̂ŎsB
@param flag[in] gpȂtrue
@return wndNULLfalse  true
*/
inline bool SetShowIME(HWND wnd, bool flag )
{
	typedef int (PASCAL *SETIME_TYPE)(HWND,int);
	if(wnd==NULL) return false;

	{
		const int num = 4;
		const char *dlltbl[num]={
			"WINNLS32.DLL","winnls.dll",
			"user32.dll","win32nls.dll"
		};
		const char *prctbl[num]={
			"WINNLSEnableIME","WINNLSEnableIME",
			"WINNLSEnableIME","@WINNLS32EnableIME"
		};
		SETIME_TYPE SetIME=NULL;
		DLLManager f;
		for(int i=0;i<num;i++){
			f.reset(dlltbl[i]);
			
			SetIME = (SETIME_TYPE)f.find(prctbl[i]);
			if(SetIME){
				SetIME(wnd,flag);
				return true;
			}
		}
	}
	return false;
}

class FolderSelector{
public:
	/*!
	@param GetPath[out] tH_̕obt@(MAX_PATH)ȏɂ邱ƁII
	@param BuffSize[in] GetPathobt@̃TCYiیłˁB
	@param folder[in] tH_w
	@param Title[in] ̃_CAÕ^Cg
	@param Flag[in] BIF_EDITBOX̂悤ȃtOwiڂBROWSEINFO
	@param WindowHandle[in] I[i[EChẼnh
	*/
	int FolderSelectLogic(char *GetPath,size_t BuffSize,
		const char *folder=NULL,const char *Title=NULL,
		UINT Flag=BIF_EDITBOX,HWND WindowHandle=NULL)
	{
		if(BuffSize == 0) return edk_FAILED;
		char *pDir = GetPath;
		pDir[0] = '\0';

		HRESULT hr;
		BROWSEINFO bi={0};
		ITEMIDLIST *lpid = NULL;
		LPMALLOC pMalloc = NULL;

		bi.hwndOwner	= WindowHandle;
		bi.ulFlags		= Flag;
		if(!Title){
			bi.lpszTitle	= "fBNgw";
		}else{
			bi.lpszTitle = Title;
		}
		if(folder){
			bi.lpfn   = BrowseCallbackProc; // R[o[N֐
			bi.lParam = (LPARAM)folder;       // tH_
		}
		//\ing
		lpid = ::SHBrowseForFolder( &bi );

		if ( lpid == NULL )
		{
			//cancelꂽB
			return edk_Not_Selected;
		}
		else
		{
			hr = ::SHGetMalloc( &pMalloc );
			if ( hr == E_FAIL )
			{
				MessageBox(WindowHandle,  "SHGetMalloc Error", "Error",MB_OK);
				return edk_FAILED;
			}

			::SHGetPathFromIDList( lpid, pDir );
			if ( pDir[strlen(pDir) - 1] != '\\' ){
				dkstrcat_amap(pDir,BuffSize,strlen(pDir),"\\",strlen("\\"));
				//strcat( pDir, "\\" );
			}

			pMalloc->Free( lpid );
			pMalloc->Release();
		}
		return edk_SUCCEEDED;
	}
	FolderSelector(char *GetPath,size_t BuffSize,const char *folder,bool *flag){
		*flag = DKUTIL_SUCCEEDED(FolderSelectLogic(GetPath,BuffSize,folder));
	}
	//ȂRXgN^B
	FolderSelector(){}
	/*!
	@param GetPath[out] tH_̃pX
	@note
	GetPathemptyIĂȂB
	*/
	FolderSelector(std::string &GetPath,const char *folder=NULL)
	{
		GetPath.clear();
		char path[MAX_PATH]="";
		FolderSelectLogic(path,sizeof(path),folder);
		GetPath = path;
	}
	// R[o[N֐
	static int CALLBACK BrowseCallbackProc( HWND hWnd, UINT uMsg, LPARAM lParam, LPARAM lpData )
	{
		// tH_I_CAȌ
		if ( (BFFM_INITIALIZED == uMsg) && lpData ){
			SendMessage( hWnd, BFFM_SETSELECTION, TRUE, lpData );
		}
		return 0;
	}//BrowseCallbackProc


};
inline bool EasyFolderSelect(char *buff,size_t buffsize){
	FolderSelector sel;
	return DKUTIL_SUCCEEDED(sel.FolderSelectLogic(buff,buffsize));
}

}//end of dkutil namespace


#endif//end of USE_DKINGYO_SHELL_AND_COMMON_CONTROL
#endif//end of include once
