/*!
@since 2003/12/20
@note
allocate_policy... ñ|V[NX
malloc͕KAobt@OɃNAĂԂB
free͕KNULLnĂ邩ǂ`FbNB
*/
#ifndef _dkutilAllocatePolicy__h_
#define _dkutilAllocatePolicy__h_

#include "dKingyoMacro.h"
#include "dkutilDefinedC.h"




namespace dkutil{


namespace policy{


struct allocate_policy_malloc{

	void * malloc(const size_t bytes)const
  { 
		void *p = DKUTIL_SAFE_MALLOC(bytes); 
		if(!p) return NULL;
		memset(p,0,bytes);
		return p; 
	}
	void free(void * block)const
  { 
		DKUTIL_SAFE_FREE(block);
	}
	void *realloc(void *block,size_t size)const{
		return (void *)DKUTIL_SAFE_REALLOC(block,size);
	}
};


struct allocate_policy_globalalloc{
	void * malloc(const size_t bytes)const
  { return ::GlobalAlloc(GMEM_FIXED | GMEM_ZEROINIT,bytes); }

	void free(void * block)const
  { 
		if(block){
			::GlobalFree(block);
		}
	}
	void *realloc(void *block,size_t size)const{
		if(block){
			return (void *)::GlobalReAlloc(block,size,NULL);//킩ȂONULL^^G
		}else{
			return malloc(size);
		}
	}

};

/*!
C^[tFCXʂɂČƁB݊̂߂Ȃ񂾁B
*/
///yaneSDK3rdyaneAllocator.h̃AP[^[C^[tFCXƌ݊^^;(Ǝv)
template<class IMPL>
class AllocatorInterface{
public:
	typedef std::size_t size_type;
  typedef std::ptrdiff_t difference_type;
private:
	IMPL ma;
public:
	///@return 0ɏ̈ւ̃|C^Ԃ
	BYTE *Alloc(int size)const{
		return ma.malloc(size);
	}
	///GlobalFreegpAlloc()Ŋmۂ̈J
	void Free(BYTE *pb)const{
		ma.free(pb);
	}
	BYTE* ReAlloc(BYTE *ptr,int size)const{
		return (BYTE *)ma.realloc(ptr,size);
	}

	///@return 0ɏ̈ւ̃|C^Ԃ Alloc()Ɠ
	char * malloc(const size_type bytes)const
  { return (char *)ma.malloc(bytes); }
  ///mallocŊmۂ̂J Free()ƓB
	void free(char * const block)const
  { ma.free(block); }

	char *realloc(char *block,size_type size)const{
		return (char *)ma.realloc((void *)block,size);
	}
};


typedef AllocatorInterface<allocate_policy_globalalloc> Win32SafeAllocator;
typedef AllocatorInterface<allocate_policy_malloc> DefaultAllocator; 


}//end of policy namespace

}//end of dkutil namespace

#endif //end of include once

