#include "stdafx.h"
#include "dKingyoMacro.h"
#include "dkutilDefinedC.h"
#include "dkutilDefined.h"
#include "dKingyoUtilClass.h"

namespace dkutil{ // begin dKingyoUtility namespace 

		


bool BitIsVisualized( char *buff,size_t buffsize,unsigned int dt ){
    int i, len;
		char *p=buff;
    len = sizeof(dt) * CHAR_BIT;
    int a=0;
		for ( i=len-1; i >= 0; i-- ){
        // rbgԂ
				if(0 > _snprintf(p,buffsize,"%u",( dt>>i ) & 0x0001))
					return false;
				p++;
		}
		return true;
}



bool CharMatch(const char *src,const char *str){
	bool r=false;
	int SrcLen=strlen(src);
	int i=0;
	for(i=0;i<SrcLen;i++){
		if( str[i]==NULL && src[i] != str[i])
			break;
	}
	if(i-1 == SrcLen)
		r=true;

	return r;
}



/*!
@note
	oTF񔽓c F KittyGW

  strnicmp - Q̕񒆂̕A啶ʂ
              r܂B

  ̊֐́AVisual C++ɂ͂邪A{[hRpCɂ
  ȂB̂߁A{[hpɍ쐬B
  @ł́A܂ɗȂ̑召͍̔sȂ
  ƂƂB

@F
    const char *string1@r镶P
    const char *string2@r镶Q
    size_t     count@@ r镶

  ߂lF
    int Q̕΂OAȂ΂PԂ
        r镶ɒBOɁȀI[ɒBꍇ́A
        ȂƂ݂ȂB

@param string1@r镶P
@param string2@r镶Q
@param r镶
@return Q̕΂OAȂ΂PԂ
r镶ɒBOɁȀI[ɒBꍇ́AȂƂ݂ȂB
*/
DINLINE int strnicmp(
    const char *string1, const char *string2, size_t count)
{
    int c1, c2;
    
    --count;
    
    for (; count ; --count){
        c1 = string1[count];
        c2 = string2[count];
        
        // ̏I[`FbN
        if (!c1) return 1;
        if (!c2) return 1;
        
        // 啶̏ꍇAɕϊ
        if ('A' <= c1 && c1 <= 'Z') c1 += 'a' - 'A';
        if ('A' <= c2 && c2 <= 'Z') c2 += 'a' - 'A';
        
        // ƂɂȂ̂ŁAr
        if (c1 != c2) return 1;
    }
    
    return 0;
}// _strnicmp




/*
char *dGetCurrentDirectory(void){
	static char str[MAX_PATH];
	::memset(str,0,sizeof(str));
	::GetCurrentDirectory(MAX_PATH,str);
	return str;
}
*/


//t@C擾ƂH



	

//**********************************************************
//Ofn
//**********************************************************



int dSentenceOut(char *filename,size_t plusbytesize,char *str,...){
	int result=-1;

	size_t strlength=strlen(str) + 1;
	size_t buffsize = strlength + plusbytesize;
	char *s = (char *)::malloc(buffsize);
	if(!s){goto dSentenceOutExit;}
	memset(s,'\0',buffsize);//
	SET_VA_LIST_INSERT_YEN_N(s,buffsize,str);
	FILE *fp;
	//t@CI[v
	if(NULL == (fp = fopen( filename , "at" )))
		goto dSentenceOutExit;
		

	// G[Ot@Cɏo
	fputs( s , fp ) ;
	fclose( fp ) ;
	result=0;
	goto dSentenceOutExit;
dSentenceOutExit:
	if(s){::free((void *)s);s=NULL;}
	return result;
}

int OutputWindowString( HWND hWnd,DWORD dwStyle,char *str,... ){
	if ( hWnd == NULL ) return -1;
	char buff[1024]="";
	SET_VA_LIST(buff,1024,str);
	//switch(dwStyle){
	//	case NULL 
	::SendMessage( hWnd, LB_ADDSTRING, 0, (long)buff );
	::SendMessage( hWnd , WM_VSCROLL, SB_LINEDOWN, 0 );
	//}
	return 0;
}


//*****************************************
//VXe񓙁A擾n
//**************************************



void GetCharOfTimeUpToMinute(char *buff,size_t buffsize,bool Sysflag)
{
	SYSTEMTIME lpSystemTime={0};
	if(Sysflag){
		GetSystemTime(
			&lpSystemTime   // address of system time structure
		);
	}else{
		GetLocalTime(&lpSystemTime);
	}
	_snprintf(buff,buffsize,"%d:%d %d/%d/%d",
		lpSystemTime.wHour,
		lpSystemTime.wMinute,
		lpSystemTime.wYear,
		lpSystemTime.wMonth,
		lpSystemTime.wDay
		);
		//10:47 2003/05/31
}
void GetCharOfMemoPadTypeTime(char *buff,size_t buffsize){
	GetCharOfTimeUpToMinute(buff,buffsize,false);
}

void GetCharOfSystemTimeAll(char *buff,size_t buffsize)
{
	SYSTEMTIME lpSystemTime={0};
	GetSystemTime(
		&lpSystemTime   // address of system time structure
	);
	LPSTR lpszDayOfWeek = NULL;
	//j̍쐬
  switch (lpSystemTime.wDayOfWeek){
  case 0: lpszDayOfWeek = "Sun";   break;
  case 1: lpszDayOfWeek = "Mon";   break;
  case 2: lpszDayOfWeek = "Tue";   break;
  case 3: lpszDayOfWeek = "Wed";   break;
  case 4: lpszDayOfWeek = "Thu";   break;
  case 5: lpszDayOfWeek = "Fri";   break;
  case 6: lpszDayOfWeek = "Sat";   break;
  }   // j̍쐬
	_snprintf(buff,buffsize,"%d:%d:%d.%d %d/%d/%d/%s",
		lpSystemTime.wHour,
		lpSystemTime.wMinute,
		lpSystemTime.wSecond,
		lpSystemTime.wMilliseconds,
		lpSystemTime.wYear,
		lpSystemTime.wMonth,
		lpSystemTime.wDay,
		lpszDayOfWeek
		);
}

void GetCharOfLocalTimeAllJapanese(char *buff,size_t buffsize){
  SYSTEMTIME  time;           //
  LPCSTR      lpszDayOfWeek;  //j

  //[JԂ̎擾
  GetLocalTime (&time);

  //j̍쐬
  switch (time.wDayOfWeek){
  case 0: lpszDayOfWeek = "";   break;
  case 1: lpszDayOfWeek = "";   break;
  case 2: lpszDayOfWeek = "";   break;
  case 3: lpszDayOfWeek = "";   break;
  case 4: lpszDayOfWeek = "";   break;
  case 5: lpszDayOfWeek = "";   break;
  case 6: lpszDayOfWeek = "y";   break;
  }   // j̍쐬

  //̏
  _snprintf(buff,buffsize,"%dN%d%di%sjj %d%d%d.%db",
      time.wYear, time.wMonth, time.wDay, lpszDayOfWeek,
      time.wHour, time.wMinute, time.wSecond, time.wMilliseconds
  );

}








void ERROR_BOX(char *str,...){
		char s[512];
		va_list VaList ;
		va_start( VaList , str ) ;
		vsprintf( s , str , VaList ) ;
		va_end( VaList ) ;
		MessageBox(NULL,s,"ERROR_BOX",MB_OK);
}

int DefaultOutputDebugString(char *str){
	OutputDebugString(str);
	return 0;
}
void Return(){
}


#define jms1(c) (((((unsigned char)(c))>=0x81)&&(((unsigned char)(c))<=0x9F))||((((unsigned char)(c))>=0xE0)&&(((unsigned char)(c))<=0xFC)))
#define jms2(c) ((((unsigned char)(c))!=0x7F)&&(((unsigned char)(c))>=0x40)&&(((unsigned char)(c))<=0xFC))

//*********************************************************
//  str  str[nPos] ɂāA
//   O cc PoCg
//   P cc QoCg̈ꕔiPoCgj
//   Q cc QoCg̈ꕔiQoCgj
// ̂ꂩԂB
//*********************************************************
int isJMS( const char *str, int nPos )
{
	int i;
	int state; // { 0, 1, 2 } = { PoCg, QoCg̑PoCg, QoCg̑QoCg }

	state = 0;
	for( i = 0; str[i] != '\0'; i++ )
	{
		if      ( ( state == 0 ) && ( jms1( str[i] ) ) ) state = 1; // 0 -> 1
		else if ( ( state == 1 ) && ( jms2( str[i] ) ) ) state = 2; // 1 -> 2
		else if ( ( state == 2 ) && ( jms1( str[i] ) ) ) state = 1; // 2 -> 1
		else                                             state = 0; // 2 -> 0, ̑

		// str[nPos] ł̏ԂԂB
		if ( i == nPos ) return state;
	}
	return 0;
}//isJMS



//memory swap;
void memswap( void *va, void *vb, size_t size )
{
	char *ca;
	char *cb;
	char  cTmp;
	for( ca = (char *)va, cb = (char *)vb; size > 0; size--, ca++, cb++ )
	{
		cTmp = *ca;
		*ca  = *cb;
		*cb  = cTmp;
	}
}//memswap



// 傫 size ̗vf num Ȃz array ̗vf
// tɕבւB
void memreverse( void *array, size_t num, size_t size )
{
	char *l;
	char *r;

	l = (char *)array;
	r = (char *)array + ((num-1) * size);
	for( ; l < r; l = l+size, r = r-size )
		memswap( l, r, size );
}//memreverse


// 傫 size ̗vf num Ȃz array ̗vf
// Eɗvf shift ]ړB
void memrrotate( void *array, size_t shift, size_t num, size_t size )
{
	memreverse( array,                      num,       size ); // 012345678 -> 876543210
	memreverse( array,                      shift,     size ); // 876543210 -> 678543210
	memreverse( (char *)array+(size*shift), num-shift, size ); // 678543210 -> 678012345
}//memrrotate


// 傫 size ̗vf num Ȃz array ̗vf
// ɗvf shift ]ړB
void memlrotate( void *array, size_t shift, size_t num, size_t size )
{
	memreverse( array,                      shift,     size ); // 012345678 -> 210345678
	memreverse( (char *)array+(size*shift), num-shift, size ); // 210345678 -> 210876543
	memreverse( array,                      num,       size ); // 210876543 -> 345678012
}//memlrotate

// [N(leap year)ǂm߂B
// [Nłΐ^AȂ΋UԂ
int IsLeapYear( int Year )
{
	return (((Year%4)==0)&&((Year%100)!=0)||((Year%400)==0));
}//IsLeapYear


// Lȓtłΐ^AȂ΋UԂ
int IsGoodDate( int Year, int Month, int Day )
{
	return ((Month>=1)&&(Month<=12)&&(Day>=1)&&(Day<=DaysInMonth(Year,Month)));
}//IsGoodDate

// w肳ꂽ̍ŏIԂ
// ͂ꂽsiP`12͈̔͊Ojł΂OԂ
int DaysInMonth( int nYear, int nMonth )
{
	const int nDaysInMonth[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

	if ( ( nMonth < 1 ) || ( nMonth > 12 ) ) return 0;
	if ( (2 == nMonth) && IsLeapYear(nYear) ) return 29;

	return nDaysInMonth[nMonth-1];
}//DaysInMonth



// OSEX(Gregorian calendar)͈͓̔ǂm߂B
// 1582N1015ȍ~łΐ^AȂ΋UԂ
int IsGregory( int Year, int Month, int Day )
{
	return ((Year>1582)||((Year==1582)&&((Month>10)||((Month==10)&&(Day>=15)))));
}//IsGregory


// ő񐔁iGreatest Common DivisorjԂB
// ɂOꍇ͂OԂB

int gcd( int m, int n )
{
	// ɂOꍇ͂OԂ
	if ( ( 0 == m ) || ( 0 == n ) )
		return 0;
	
	// [Nbȟݏ@
	while( m != n )
	{
		if ( m > n ) m = m - n;
		else         n = n - m;
	}
	return m;
}//gcd

// ŏ{iLeast Common MultiplejԂB
// ɂOꍇ͂OԂB
int lcm( int m, int n )
{
	// ɂOꍇ͂OԂ
	if ( ( 0 == m ) || ( 0 == n ) )
		return 0;
	
	return ((m / gcd(m, n)) * n); // lcm = m * n / gcd(m,n)
}//lcm



} // the end of dKingyoUtility namespace


/*
class dURLEncode{
protected:
public:
	dURLEncode(){}
	virtual ~dURLEncode(){}
	virtual int TwoHex2Int(char c1, char c2) {
		int Hi = c1, Lo = c2 , Result;
    
		if ('0'<=Hi && Hi<='9')      Hi -= '0';
		else if ('a'<=Hi && Hi<='f') Hi -= ('a'-10);
		else if ('A'<=Hi && Hi<='F') Hi -= ('A'-10);
    
		if ('0'<=Lo && Lo<='9')      Lo -= '0';
		else if ('a'<=Lo && Lo<='f') Lo -= ('a'-10);
		else if ('A'<=Lo && Lo<='F') Lo -= ('A'-10);

		Result = Lo + 16*Hi;
		return Result;
	}
	
	 // URLGR[h
	 //  ̕ URLGR[hԂ
	 //
	int URLEncode(char *src,char *buff,size_t buffsize)
	{
		int len;
		char *DestString=(char *)malloc(len=strlen(src));
		memset(DestString,0,len);
		for(int i=0; i<len; i++)
		{
			char c = src[i];
			//if( isalnum(c) )  // Alpha Numeric Char
			if (  (c>=48 && c<= 57) || ( c>= 65 && c<= 90) || (c>= 97 && c<= 122) ) {
				//DestString += c;
				strncat(DestString,&c,len);
			} 
			else if(c == ' ') { // Space Char
				strncat(DestString,"+",len);
			} 
			else {              // Other Char
				char temp[512];
				//temp.Format("%%%02x", (unsigned char)c);
				_snprintf( temp,512,"%%%02x",(unsigned char)c);
				strncat(DestString,temp,len);
			}
		}
		strncpy(buff,DestString,buffsize);
		free(DestString);
		return 0;
	}

};

class dURLEncode_of_MFC : public dURLEncode{
public:
	dURLEncode_of_MFC(){}
	virtual ~dURLEncode_of_MFC(){}
	

 // URLGR[h
   //̕ URLGR[hԂ
 
	CString URLEncode(CString & SrcString)
	{
		CString DestString;
		int len = SrcString.GetLength();
		for(int i=0; i<len; i++)
		{
			TCHAR c = SrcString[i];
			//if( isalnum(c) )  // Alpha Numeric Char
			if (  (c>=48 && c<= 57) || ( c>= 65 && c<= 90) || (c>= 97 && c<= 122) ) {
				DestString += c;
			} 
			else if(c == ' ') { // Space Char
				DestString += "+";
			} 
			else {              // Other Char
				CString temp;
				temp.Format("%%%02x", (unsigned char)c);
				DestString += temp;
			}
		}
		return DestString;
	}
	
	 // URLfR[h
	 //  ̕ URLfR[hԂ
	 
	CString URLDecode(CString & SrcString)
	{
		CString DestString;
		int len = SrcString.GetLength();
		for(int i=0; i<len; i++)
		{
			if(SrcString[i]=='%') {      // Non Alpha Numeric Char
				i++;
				if (isxdigit(SrcString[i]) && isxdigit(SrcString[i+1])) {
					DestString += (TCHAR) TwoHex2Int(SrcString[i], SrcString[i+1]);
					
					i++;
				}
			}
			else if(SrcString[i]=='+') { // Space Char
				DestString += " ";
			}
			else {                       // Other Char
				DestString += SrcString[i];
			}
		}
		return DestString;
	}
};





*/

