

/*!
@since 2003/12/28
@note
<b>Ql</b>
HP<br>
Menu: Program -> BlowfishŃt@CÍ<br>
http://www22.big.or.jp/~qul/, Access 2003/12/28<br>


*/
#ifndef _dkutil_Encrypt_h__
#define _dkutil_Encrypt_h__

#include "blowfish.h"
#include "../dkutilBuffer.h"

namespace dkutil{

namespace policy{

///ȈՌ^BlowFish̃GR[hfR[hB
class BlowFishCrypt{
protected:
	bool mInited;
	CBlowFish mBlowFish;
public:
	///@return włL[̍Œ̒𓾂
	size_t key_max()const{return MAXKEYBYTES;}
	BlowFishCrypt(const BYTE *key,size_t keysize){
		
		if(init(key,keysize)) return;
		mInited = false;
	}
	virtual ~BlowFishCrypt(){end();}
	/*!
	@param key[in] L[ւBYTE^̔z
	@param keysize[in] L[̃TCY
	*/
	///L[w肵ďB
	bool init(const BYTE *key,size_t keysize){
		if(keysize > key_max())return false;
		BYTE buff[MAXKEYBYTES + 1];
		NULL_CHAR_ARRAY(buff);
		if(DKUTIL_FAILED(dkmemcpy(buff,sizeof(buff),key,keysize)))
		{
			return false;
		}
		mBlowFish.Initialize(buff,keysize);
		mInited = true;
		return true;
	}
	/*!
	@param src[in] Íf[^bufferւ̃|C^
	@param srcsize[in] src̃TCY
	@param dest[out] Í̃f[^̊i[
	@param result[out] Encodef[^̃TCY炵́iڂCBlowFishNXEncode̖߂lׂI
	@note
	result̒ǉ͕ς\B
	*/
	bool encode(BYTE *src,size_t srcsize,byte_buffer &dest,DWORD *result = NULL){
		if(src==NULL || srcsize == 0) return false;
		if(false==mInited) return false;


		size_t realsize = mBlowFish.GetOutputLength(srcsize);
		//dest.clear();
		dest.resize(realsize);// + 1̂ȂH(ʖڂB)
		DWORD r = mBlowFish.Encode((BYTE *)src,dest.data(),dest.size());
		if(result){
			*result = r;
		}
		return true;
	}
	/*!
	@param src[in] f[^bufferւ̃|C^
	@param srcsize[in] src̃TCY
	@param dest[out] ̃f[^̊i[
	@note
	*/
	bool decode(BYTE *src,size_t srcsize,byte_buffer &dest){
		if(src==NULL || srcsize==0) return false;
		if(false==mInited) return false;

		size_t realsize = mBlowFish.GetOutputLength(srcsize);
		dest.resize(realsize);
		mBlowFish.Decode((BYTE *)src,dest.data(),dest.size());
		return true;//(maybe...)
	}
	///̃NXIB܂gꍇinitłĂяoĂ^^G
	void end(){
		if(mInited==true){
			mInited=false;
		}
	}
};


}//end of policy namespace


}//end of dkutil namespace

#endif