/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE MP3FRAUNHOFERWRITER SOURCE CODE.        *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE MP3FRAUNHOFERWRITER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha  *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#include "MP3FraunhoferWriter.h"

// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::GetInFormat(WAVEFORMATEX *pwf)
{  // ̓s̃tH[}bg擾

   ::CopyMemory(pwf, &m_inFormat, sizeof(m_inFormat));
   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::CheckBitrate(int nOutBitrate)
{  // nOutBitratẽrbg[gŏo͂ł邩`FbN

   return m_pAcmFraunhofer->CheckFormat(&m_inFormat, nOutBitrate);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::CheckBitrate(WAVEFORMATEX *pInFormat, int nOutBitrate)
{  // pInFormat̓͂̏ꍇɁAnOutBitratẽrbg[gŏo͂ł邩`FbN

   return m_pAcmFraunhofer->CheckFormat(pInFormat, nOutBitrate);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::GetBitrate(int *pnOutBitrate)
{  // o͂̃rbg[g擾

   *pnOutBitrate = m_nBitrate;
   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::SetBitrate(int nOutBitrate)
{  // o͂̃rbg[gݒ肷

   m_nBitrate = nOutBitrate;
   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::StartStreaming()
{
   // ͂̃f[^TCY擾
   HRESULT hr;
   ALLOCATOR_PROPERTIES InProps;
   IMemAllocator * pInAlloc = NULL;

   hr = GetAllocator(&pInAlloc);
   if(FAILED(hr)) return hr;

   hr = pInAlloc->GetProperties(&InProps);
   if(FAILED(hr))
   {
      SAFE_RELEASE(pInAlloc);
      return hr;
   }

   SAFE_RELEASE(pInAlloc);

   // acm
   hr = m_pAcmFraunhofer->ConvertInit(&m_inFormat, InProps.cbBuffer * 12 / 10, m_nBitrate);

   if(hr != S_OK)
      return E_FAIL;

   if(m_hFile == NULL)
   {
      // t@C쐬
      m_hFile = ::CreateFile(m_awFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, (DWORD)0, NULL);
   }

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::Receive(IMediaSample *pSample)
{
   HRESULT hr;

   CAutoLock lock(m_pReceiveLock);

   BYTE *pbData;
   hr = pSample->GetPointer(&pbData);
   if(FAILED(hr))
      return hr;

   int nLength = 0;

   // acmŕϊ
   hr = m_pAcmFraunhofer->Convert(m_hFile, pbData, pSample->GetActualDataLength());

   if(hr != S_OK)
      return S_FALSE;

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::Stop()
{  // tB^~ꂽꍇɌĂ΂

   CAutoLock cObjectLock(m_pLock);

   if(m_hFile != NULL)
   {  // t@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::EndOfStream(void)
{  // 󂯎f[^ȂꍇɌĂ΂

   CAutoLock lock(m_pReceiveLock);

   // acmŕϊ
   m_pAcmFraunhofer->ConvertEnd(m_hFile);

   if(m_hFile != NULL)
   {  // t@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   return CRenderedInputPin::EndOfStream();
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::CheckMediaType(const CMediaType *pMediaType)
{  // ̓sق̃sƌqɌĂ΂

   if(*pMediaType->Type() == MEDIATYPE_Audio && *pMediaType->Subtype() == MEDIASUBTYPE_PCM)
   {
      if(*pMediaType->FormatType() == FORMAT_WaveFormatEx)
      {
         WAVEFORMATEX *pwf = (WAVEFORMATEX *)pMediaType->Format();

         if(pwf->wFormatTag == WAVE_FORMAT_PCM && pwf->wBitsPerSample == 16 && pwf->nSamplesPerSec <= 48000)
         {
            ::CopyMemory(&m_inFormat, (WAVEFORMATEX *)pMediaType->Format(), sizeof(m_inFormat));
            return S_OK;
         }
      }
   }

   return S_FALSE;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::BreakConnect()
{
   if(m_pFilter->m_pPosition != NULL)
      m_pFilter->m_pPosition->ForceRefresh();

   return CRenderedInputPin::BreakConnect();
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::SetFileName(LPCOLESTR pszFileName)
{
   // t@Ci[Ă
   lstrcpyW(m_awFileName, pszFileName);

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CInputPin::CInputPin(CMP3FraunhoferWriter *pFilter, LPUNKNOWN pUnk, CCritSec *pLock, CCritSec *pReceiveLock, HRESULT *phr)
   : CRenderedInputPin(NAME("Input"), pFilter, pLock, phr, L"Input"), m_pReceiveLock(pReceiveLock), m_pFilter(pFilter)
{  // CInputPiñRXgN^

   // ϐ̏
   m_nBitrate = 0;
   m_pAcmFraunhofer = new CAcmFraunhofer();
   m_hFile = NULL;
}
// ------------------------------------------------------------------------------------------------------------------------
CInputPin::~CInputPin()
{  // CInputPiñfXgN^

   if(m_hFile != NULL)
   {  // ܂t@CĂȂȂAt@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   if(m_pAcmFraunhofer != NULL)
   {
      delete m_pAcmFraunhofer;
      m_pAcmFraunhofer = NULL;
   }
}
// ------------------------------------------------------------------------------------------------------------------------
