require 'darkhall/const'

module DarkHall
	class Rule < StorableObject
		KEYS = %w(
			common_enemy_ability_bonus
			boss_ability_bonus

			enemy_exp_rate
			enemy_gold_rate
			visionary_paper_available
		)
		
		KEYS.each{|x| attr_reader(x)}
		bool_attr_reader :visionary_paper_available
	
		def initialize(params = {})
			init_params(params)
			
			params.each_pair do |key, value|
				instance_variable_set("@#{key}", value)
			end
		end
		
		def init_params(params = {})
			@common_enemy_ability_bonus = 0
			@boss_ability_bonus = 0

			@enemy_exp_rate = 1.0
			@enemy_gold_rate = 1.0
			
			@visionary_paper_available = false
		end
		
		def self.create_from_mpac_model(data)
			self.new
		end
	end
	
	class ShortTimeRule < Rule
		def init_params(params = {})
			super
			@enemy_exp_rate = 1.5
			@enemy_gold_rate = 2.0
			
			@visionary_paper_available = true
		end
	end
	
	class NormalRule < Rule
	end
	
	class HardRule < Rule
		def init_params(params = {})
			super
			@common_enemy_ability_bonus = +4
			@boss_ability_bonus = +8

			@enemy_exp_rate = 1.0
			@enemy_gold_rate = 0.5
		end
	end
	
	class CustomRule < Rule		
		def self.create_from_mpac_model(data)
			self.new(data)
		end
		
		def dump
			re = {}
			KEYS.each do |key|
				re[key] = instance_variable_get("@#{key}")
			end
		end
	end
end



